/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield;

import com.atlassian.greenhopper.customfield.CustomFieldScreenService;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntity;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.ScreenableIssueOperation;
import com.atlassian.jira.project.Project;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomFieldScreenServiceImpl
implements CustomFieldScreenService {
    private final LoggerWrapper logger = LoggerWrapper.with(this.getClass());
    @Autowired
    private FieldScreenManager fieldScreenManager;
    @Autowired
    private IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;

    @VisibleForTesting
    void addFieldToScreen(FieldScreen screen, CustomField field, @Nullable Integer position) {
        List tabs = this.fieldScreenManager.getFieldScreenTabs(screen);
        FieldScreenTab fieldScreenTab = (FieldScreenTab)tabs.get(0);
        FieldScreenLayoutItem existingFieldLayoutItem = fieldScreenTab.getFieldScreenLayoutItem(field.getId());
        if (existingFieldLayoutItem != null) {
            if (position != null) {
                HashMap<Integer, FieldScreenLayoutItem> positionToItem = new HashMap<Integer, FieldScreenLayoutItem>();
                positionToItem.put(position, existingFieldLayoutItem);
                fieldScreenTab.moveFieldScreenLayoutItemToPosition(positionToItem);
            }
        } else if (position != null) {
            fieldScreenTab.addFieldScreenLayoutItem(field.getId(), position.intValue());
        } else {
            fieldScreenTab.addFieldScreenLayoutItem(field.getId());
        }
    }

    @Override
    public void addFieldForIssueOperations(Project project, CustomField field, @Nullable Integer position, @Nullable String issueTypeId, ScreenableIssueOperation ... operations) {
        IssueTypeScreenScheme issueTypeScreenScheme = this.issueTypeScreenSchemeManager.getIssueTypeScreenScheme(project);
        LinkedHashSet<FieldScreenScheme> screenSchemes = new LinkedHashSet<FieldScreenScheme>();
        if (issueTypeId == null) {
            for (IssueTypeScreenSchemeEntity entity : issueTypeScreenScheme.getEntities()) {
                screenSchemes.add(entity.getFieldScreenScheme());
            }
        } else {
            this.addScreenScheme(issueTypeId, screenSchemes, issueTypeScreenScheme);
        }
        LinkedHashSet<FieldScreen> screens = new LinkedHashSet<FieldScreen>();
        for (ScreenableIssueOperation operation : operations) {
            screens.addAll(this.getScreensForOperation(screenSchemes, operation));
        }
        this.addFieldToScreens(screens, field, position);
    }

    private void addFieldToScreens(Set<FieldScreen> screens, CustomField field, Integer position) {
        for (FieldScreen screen : screens) {
            this.addFieldToScreen(screen, field, position);
        }
    }

    private void addScreenScheme(String issueTypeId, Set<FieldScreenScheme> screenSchemes, IssueTypeScreenScheme issueTypeScreenScheme) {
        IssueTypeScreenSchemeEntity screenSchemeEntity = issueTypeScreenScheme.getEntity(issueTypeId);
        if (screenSchemeEntity == null) {
            this.addDefaultScreenScheme(screenSchemes, issueTypeScreenScheme);
        } else {
            screenSchemes.add(screenSchemeEntity.getFieldScreenScheme());
        }
    }

    private void addDefaultScreenScheme(Collection<FieldScreenScheme> screenSchemes, IssueTypeScreenScheme issueTypeScreenScheme) {
        IssueTypeScreenSchemeEntity defaultEntity = issueTypeScreenScheme.getEntity(null);
        if (defaultEntity != null) {
            screenSchemes.add(defaultEntity.getFieldScreenScheme());
        } else {
            this.logger.warn("For some reason there is no Default Screen Scheme associated in Issue Type Screen Scheme '%s' (%d). GH will ignore this ITSS.", issueTypeScreenScheme.getName(), issueTypeScreenScheme.getId());
        }
    }

    private Set<FieldScreen> getScreensForOperation(Collection<FieldScreenScheme> screenSchemes, ScreenableIssueOperation issueOperationId) {
        LinkedHashSet<FieldScreen> screens = new LinkedHashSet<FieldScreen>();
        for (FieldScreenScheme fieldScreenScheme : screenSchemes) {
            try {
                screens.add(fieldScreenScheme.getFieldScreen((IssueOperation)issueOperationId));
            }
            catch (IllegalArgumentException e) {
                this.logger.warn(e.getMessage(), new Object[0]);
            }
        }
        return screens;
    }
}

