/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield;

import com.atlassian.greenhopper.model.AbstractBuilder;
import com.atlassian.greenhopper.service.issue.IssueTypePrototype;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class CustomFieldMetadata {
    private final String fieldName;
    private final String fieldDescription;
    private final String fieldType;
    private final String fieldSearcher;
    private final Set<IssueTypePrototype> issueTypePrototypes;
    private final List<String> optionNames;
    private final String defaultOptionName;
    private final boolean lockField;
    private final boolean requireField;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CustomFieldMetadata source) {
        return Builder.from(source);
    }

    private static Set<IssueTypePrototype> transforIssueTypes(IssueTypePrototype ... issueTypePrototypes) {
        HashSet<IssueTypePrototype> prototypeSet = new HashSet<IssueTypePrototype>(Arrays.asList(issueTypePrototypes));
        if (prototypeSet.isEmpty()) {
            prototypeSet.add(IssueTypePrototype.ALL);
        }
        return prototypeSet;
    }

    @Deprecated
    public CustomFieldMetadata(String fieldName, String fieldDescription, String fieldType, String fieldSearcher, IssueTypePrototype ... issueTypePrototypes) {
        this(fieldName, fieldDescription, fieldType, fieldSearcher, CustomFieldMetadata.transforIssueTypes(issueTypePrototypes), Collections.emptyList(), null, false, false);
    }

    @Deprecated
    public CustomFieldMetadata(String fieldName, String fieldDescription, String fieldType, String fieldSearcher, Set<IssueTypePrototype> issueTypePrototypes) {
        this(fieldName, fieldDescription, fieldType, fieldSearcher, issueTypePrototypes, Collections.emptyList(), null, false, false);
    }

    CustomFieldMetadata(String fieldName, String fieldDescription, String fieldType, String fieldSearcher, Set<IssueTypePrototype> issueTypePrototypes, List<String> optionNames, String defaultOptionName, boolean lockField, boolean requireField) {
        this.fieldName = fieldName;
        this.fieldDescription = fieldDescription;
        this.fieldType = fieldType;
        this.fieldSearcher = fieldSearcher;
        this.issueTypePrototypes = issueTypePrototypes;
        this.optionNames = optionNames;
        this.defaultOptionName = defaultOptionName;
        this.lockField = lockField;
        this.requireField = requireField;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldDescription() {
        return this.fieldDescription;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public String getFieldSearcher() {
        return this.fieldSearcher;
    }

    public Set<IssueTypePrototype> getIssueTypePrototypes() {
        return this.issueTypePrototypes;
    }

    public List<String> getOptionNames() {
        return this.optionNames;
    }

    public String getDefaultOptionName() {
        return this.defaultOptionName;
    }

    public boolean isLockField() {
        return this.lockField;
    }

    public boolean isRequireField() {
        return this.requireField;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("fieldName", (Object)this.fieldName).append("fieldDescription", (Object)this.fieldDescription).append("fieldType", (Object)this.fieldType).append("fieldSearcher", (Object)this.fieldSearcher).append("issueTypePrototypes", this.issueTypePrototypes).append("optionNames", this.optionNames).append("defaultOptionName", (Object)this.defaultOptionName).append("lockField", this.lockField).append("requireField", this.requireField).toString();
    }

    public static class Builder
    extends AbstractBuilder<CustomFieldMetadata> {
        private String fieldName;
        private String fieldDescription;
        private String fieldType;
        private String fieldSearcher;
        private Set<IssueTypePrototype> issueTypePrototypes = new HashSet<IssueTypePrototype>();
        private List<String> optionNames = new ArrayList<String>();
        private String defaultOptionName;
        private boolean lockField;
        private boolean requireField;

        public static Builder from(CustomFieldMetadata source) {
            return new Builder(source.fieldName, source.fieldDescription, source.fieldType, source.fieldSearcher, new HashSet<IssueTypePrototype>(source.getIssueTypePrototypes()), new ArrayList<String>(source.optionNames), source.defaultOptionName, source.lockField, source.requireField);
        }

        public Builder() {
        }

        public Builder(String fieldName, String fieldDescription, String fieldType, String fieldSearcher, Set<IssueTypePrototype> issueTypePrototypes, List<String> optionNames, String defaultOptionName, boolean lockField, boolean requireField) {
            this.fieldName = fieldName;
            this.fieldDescription = fieldDescription;
            this.fieldType = fieldType;
            this.fieldSearcher = fieldSearcher;
            this.issueTypePrototypes = issueTypePrototypes;
            this.optionNames = optionNames;
            this.defaultOptionName = defaultOptionName;
            this.lockField = lockField;
            this.requireField = requireField;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Builder setFieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public String getFieldDescription() {
            return this.fieldDescription;
        }

        public Builder setFieldDescription(String fieldDescription) {
            this.fieldDescription = fieldDescription;
            return this;
        }

        public String getFieldType() {
            return this.fieldType;
        }

        public Builder setFieldType(String fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        public String getFieldSearcher() {
            return this.fieldSearcher;
        }

        public Builder setFieldSearcher(String fieldSearcher) {
            this.fieldSearcher = fieldSearcher;
            return this;
        }

        public Set<IssueTypePrototype> getIssueTypePrototypes() {
            return this.issueTypePrototypes;
        }

        public Builder setIssueTypePrototypes(Set<IssueTypePrototype> issueTypeIds) {
            this.issueTypePrototypes = this.issueTypePrototypes;
            return this;
        }

        public Builder setIssueTypePrototypes(IssueTypePrototype ... issueTypes) {
            this.issueTypePrototypes.clear();
            this.issueTypePrototypes.addAll(Arrays.asList(issueTypes));
            return this;
        }

        public Builder setOptionNames(String ... optionNames) {
            this.optionNames.clear();
            this.optionNames.addAll(Arrays.asList(optionNames));
            return this;
        }

        public Builder setDefaultOptionName(String defaultOptionName) {
            if (this.optionNames.contains(defaultOptionName)) {
                this.defaultOptionName = defaultOptionName;
            }
            return this;
        }

        public Builder setLockField(boolean lockField) {
            this.lockField = lockField;
            return this;
        }

        public boolean isLockField() {
            return this.lockField;
        }

        public Builder setRequireField(boolean requireField) {
            this.requireField = requireField;
            return this;
        }

        public boolean isRequireField() {
            return this.requireField;
        }

        @Override
        public CustomFieldMetadata build() {
            return new CustomFieldMetadata(this.fieldName, this.fieldDescription, this.fieldType, this.fieldSearcher, this.issueTypePrototypes, this.optionNames, this.defaultOptionName, this.lockField, this.requireField);
        }
    }
}

