/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield;

import com.atlassian.greenhopper.customfield.CustomFieldConfigurationRestorer;
import com.atlassian.greenhopper.customfield.CustomFieldMetadata;
import com.atlassian.greenhopper.customfield.CustomFieldScreenService;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.issue.fields.FlagCustomFieldProvider;
import com.atlassian.greenhopper.manager.issue.fields.ManagedFieldConfigurationRestorer;
import com.atlassian.greenhopper.manager.issue.fields.StoryPointsCustomFieldProvider;
import com.atlassian.greenhopper.project.ProjectType;
import com.atlassian.greenhopper.service.issue.IssueTypePrototype;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.greenhopper.service.sprint.SprintCustomFieldService;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.operation.ScreenableIssueOperation;
import com.atlassian.jira.project.Project;
import io.atlassian.fugue.Pair;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomFieldConfigurationRestorerImpl
implements CustomFieldConfigurationRestorer {
    private static final LoggerWrapper LOG = LoggerWrapper.with(CustomFieldConfigurationRestorerImpl.class);
    @Autowired
    private CustomFieldScreenService customFieldScreenService;
    @Autowired
    private EpicCustomFieldService epicCustomFieldService;
    @Autowired
    private IssueTypeService issueTypeService;
    @Autowired
    private ManagedFieldConfigurationRestorer managedFieldConfigurationRestorer;
    @Autowired
    private SprintCustomFieldService sprintCustomFieldService;
    @Autowired
    private StoryPointsCustomFieldProvider storyPointsCustomFieldProvider;
    @Autowired
    private FlagCustomFieldProvider flagCustomFieldProvider;

    @Override
    public void ensureFieldsAreCorrectlyConfigured(Collection<Project> projects, ProjectType type, CustomFieldConfigurationRestorer.ScreenSchemeOption screenSchemeOption) {
        this.storyPointsCustomFieldProvider.ensureFieldHasCorrectContext();
        this.flagCustomFieldProvider.ensureFieldHasCorrectContext();
        Collection<Pair<CustomField, CustomFieldMetadata>> customFields = this.managedFieldConfigurationRestorer.ensureFieldsHaveCorrectContextConfiguration();
        if (screenSchemeOption == CustomFieldConfigurationRestorer.ScreenSchemeOption.UPDATE_SCREEN_SCHEME) {
            projects.forEach(project -> this.addCustomFieldsToScreens((Project)project, type, customFields));
        }
    }

    private void addCustomFieldsToScreens(Project project, ProjectType type, Collection<Pair<CustomField, CustomFieldMetadata>> customFields) {
        for (Pair<CustomField, CustomFieldMetadata> customFieldData : customFields) {
            CustomFieldMetadata customFieldMetadata = (CustomFieldMetadata)customFieldData.right();
            if (!customFieldMetadata.isRequireField()) continue;
            for (IssueTypePrototype issueTypePrototype : customFieldMetadata.getIssueTypePrototypes()) {
                if (issueTypePrototype == IssueTypePrototype.ALL) continue;
                CustomField customField = (CustomField)customFieldData.left();
                String issueTypeId = this.issueTypeService.getIssueTypeId(issueTypePrototype);
                this.addFieldToScreens(project, customField, 0, issueTypeId, IssueOperations.CREATE_ISSUE_OPERATION);
            }
        }
        CustomField epicLinkField = this.epicCustomFieldService.getDefaultEpicLinkField();
        this.addFieldToScreens(project, epicLinkField, null, null, IssueOperations.VIEW_ISSUE_OPERATION);
        if (ProjectType.SCRUM.equals((Object)type)) {
            CustomField sprintField = this.sprintCustomFieldService.getDefaultSprintField();
            this.addFieldToScreens(project, sprintField, null, null, IssueOperations.CREATE_ISSUE_OPERATION, IssueOperations.EDIT_ISSUE_OPERATION, IssueOperations.VIEW_ISSUE_OPERATION);
        }
    }

    private void addFieldToScreens(Project project, CustomField customField, Integer position, String issueTypeId, ScreenableIssueOperation ... operations) {
        if (customField != null) {
            LOG.info("Associated CustomField '%s' with ID '%s' with the project screens", customField.getName(), customField.getId());
            this.customFieldScreenService.addFieldForIssueOperations(project, customField, position, issueTypeId, operations);
        }
    }
}

