/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.confluence.rpc;

import com.atlassian.greenhopper.confluence.Builder;
import com.atlassian.jira.util.xml.SecureXmlEntityResolver;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractConfluenceSaxHandler<T, B extends Builder<T>>
extends DefaultHandler {
    private final List<T> entities = new ArrayList<T>();
    private final StringBuilder currentString = new StringBuilder();
    private Fault fault = null;
    private final B builder;
    private NameValuePair currentMember;
    public static final SecureXmlEntityResolver EMPTY_ENTITY_RESOLVER = new SecureXmlEntityResolver();

    protected AbstractConfluenceSaxHandler(B builder) {
        this.builder = builder;
    }

    public List<T> getEntities() {
        return this.entities;
    }

    public boolean hasFault() {
        return this.fault != null;
    }

    public String getFaultString() {
        return this.fault.getFaultString();
    }

    protected abstract void addMember(NameValuePair var1, B var2);

    private void addFaultMember(NameValuePair member) {
        if (this.fault != null && "faultString".equals(member.getName())) {
            this.fault.setFaultString(member.getValue());
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("struct".equals(qName)) {
            this.builder.clear();
        } else if ("member".equals(qName)) {
            this.currentMember = new NameValuePair();
        } else if ("fault".equals(qName)) {
            this.fault = new Fault();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentString.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("struct".equals(qName)) {
            this.entities.add(this.builder.build());
            this.builder.clear();
        } else if ("member".equals(qName)) {
            this.addFaultMember(this.currentMember);
            this.addMember(this.currentMember, this.builder);
            this.currentMember = null;
        } else if ("name".equals(qName)) {
            if (this.currentMember != null) {
                this.currentMember.setName(this.currentString.toString());
            }
        } else if ("value".equals(qName) && this.currentMember != null) {
            this.currentMember.setValue(this.currentString.toString());
        }
        this.currentString.setLength(0);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        return EMPTY_ENTITY_RESOLVER.resolveEntity(publicId, systemId);
    }

    private static class Fault {
        private String faultString;

        private Fault() {
        }

        public String getFaultString() {
            return this.faultString;
        }

        public void setFaultString(String faultString) {
            this.faultString = faultString;
        }
    }

    protected static class NameValuePair {
        private String name;
        private String value;

        protected NameValuePair() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

