/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.cache;

import com.atlassian.cache.compat.CacheFactory;
import com.atlassian.cache.compat.CacheSettings;
import com.atlassian.cache.compat.CacheSettingsBuilder;
import com.atlassian.cache.compat.CompatibilityCacheFactory;
import com.atlassian.greenhopper.global.LoggerWrapper;
import io.atlassian.util.concurrent.LazyReference;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Service;

@Service
public class CacheFactoryManager {
    private LoggerWrapper log = LoggerWrapper.with(CacheFactoryManager.class);
    private final LazyReference<CacheFactory> cacheManagerRef = new LazyReference<CacheFactory>(){

        @Override
        protected CacheFactory create() throws Exception {
            return new CompatibilityCacheFactory();
        }
    };

    public static CacheSettings defaultCacheSettings() {
        return new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build();
    }

    public CacheFactory create() {
        return this.cacheManagerRef.get();
    }
}

