/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.auditing.items;

import com.atlassian.greenhopper.auditing.items.AffectedBoard;
import com.atlassian.greenhopper.manager.rapidview.RapidViewManager;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.jira.auditing.AssociatedItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AffectedSprint
implements AssociatedItem {
    private Long id;
    private String name;
    private Long rapidViewId;
    private RapidView parent;

    public AffectedSprint(Sprint sprint, RapidViewManager rapidViewManager) {
        this.id = sprint.getId();
        this.name = sprint.getName();
        this.rapidViewId = sprint.getRapidViewId();
        rapidViewManager.get(this.rapidViewId).get();
        this.parent = rapidViewManager.get(this.rapidViewId).get();
    }

    @Nonnull
    public String getObjectName() {
        return this.name;
    }

    @Nullable
    public String getObjectId() {
        return Long.toString(this.id);
    }

    @Nullable
    public String getParentName() {
        return this.parent.getName();
    }

    @Nullable
    public String getParentId() {
        return Long.toString(this.rapidViewId);
    }

    @Nonnull
    public AssociatedItem.Type getObjectType() {
        return AssociatedItem.Type.SPRINT;
    }

    public AffectedBoard getParent() {
        return new AffectedBoard(this.parent);
    }
}

