/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.auditing.handlers;

import com.atlassian.greenhopper.api.events.sprint.SprintDeletedEvent;
import com.atlassian.greenhopper.auditing.items.AffectedSprint;
import com.atlassian.greenhopper.manager.rapidview.RapidViewManager;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.security.JiraAuthenticationContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SprintEventHandler {
    @Autowired
    JiraAuthenticationContext context;
    @Autowired
    RapidViewManager rapidViewManager;

    public RecordRequest handleSprintDeletedEvent(SprintDeletedEvent event) {
        AffectedSprint sprint = new AffectedSprint(event.getSprint(), this.rapidViewManager);
        return new RecordRequest(AuditingCategory.SPRINTS, this.getText("gh.boards.audit.sprint.deleted")).forObject((AssociatedItem)sprint).withAssociatedItems(new AssociatedItem[]{sprint.getParent()});
    }

    private String getText(String key) {
        return this.context.getI18nHelper().getText(key);
    }
}

