/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.auditing.handlers;

import com.atlassian.greenhopper.api.events.board.BoardCreatedEvent;
import com.atlassian.greenhopper.api.events.board.BoardDeletedEvent;
import com.atlassian.greenhopper.auditing.items.AffectedBoard;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.security.JiraAuthenticationContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BoardEventHandler {
    @Autowired
    JiraAuthenticationContext context;

    public RecordRequest handleBoardCreatedEvent(BoardCreatedEvent event) {
        AffectedBoard board = new AffectedBoard(event.getBoard());
        return new RecordRequest(AuditingCategory.BOARDS, this.getText("gh.boards.audit.board.created")).forObject((AssociatedItem)board).withAssociatedItems(new AssociatedItem[]{board});
    }

    public RecordRequest handleBoardDeletedEvent(BoardDeletedEvent event) {
        AffectedBoard board = new AffectedBoard(event.getBoard());
        return new RecordRequest(AuditingCategory.BOARDS, this.getText("gh.boards.audit.board.deleted")).forObject((AssociatedItem)board).withAssociatedItems(new AssociatedItem[]{board});
    }

    private String getText(String key) {
        return this.context.getI18nHelper().getText(key);
    }
}

