/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.auditing;

import com.atlassian.event.api.EventListener;
import com.atlassian.greenhopper.api.events.board.BoardCreatedEvent;
import com.atlassian.greenhopper.api.events.board.BoardDeletedEvent;
import com.atlassian.greenhopper.api.events.sprint.SprintDeletedEvent;
import com.atlassian.greenhopper.auditing.handlers.BoardEventHandler;
import com.atlassian.greenhopper.auditing.handlers.SprintEventHandler;
import com.atlassian.jira.auditing.AuditingManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuditingEventListener {
    @Autowired
    AuditingManager auditingManager;
    @Autowired
    SprintEventHandler sprintEventHandler;
    @Autowired
    BoardEventHandler boardEventHandler;

    @EventListener
    public void onSprintDeleted(SprintDeletedEvent event) {
        this.auditingManager.store(this.sprintEventHandler.handleSprintDeletedEvent(event));
    }

    @EventListener
    public void onBoardCreated(BoardCreatedEvent event) {
        this.auditingManager.store(this.boardEventHandler.handleBoardCreatedEvent(event));
    }

    @EventListener
    public void onBoardDeleted(BoardDeletedEvent event) {
        this.auditingManager.store(this.boardEventHandler.handleBoardDeletedEvent(event));
    }
}

