/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest.util;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.user.ApplicationUser;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectFinder {
    private static final Pattern PROJECT_ID_PATTERN = Pattern.compile("^[1-9]\\d{0,17}$");
    private final ProjectService projectService;

    @Autowired
    public ProjectFinder(ProjectService projectService) {
        this.projectService = projectService;
    }

    public ProjectService.GetProjectResult getGetProjectByIdOrKey(ApplicationUser user, String projectIdOrKey) {
        return this.isProjectId(projectIdOrKey) ? this.projectService.getProjectById(user, Long.valueOf(Long.parseLong(projectIdOrKey))) : this.projectService.getProjectByKey(user, projectIdOrKey);
    }

    private boolean isProjectId(String projectIdOrKey) {
        return PROJECT_ID_PATTERN.matcher(projectIdOrKey).matches();
    }
}

