/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest.util;

import com.atlassian.greenhopper.api.rest.bean.BoardIssueBeanFactory;
import com.atlassian.greenhopper.api.rest.util.BoardResourceHelper;
import com.atlassian.greenhopper.api.rest.util.Requests;
import com.atlassian.greenhopper.api.rest.util.ResponseFactory;
import com.atlassian.greenhopper.api.rest.util.ServiceOutcomeImpl;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.Page;
import com.atlassian.greenhopper.service.PageRequest;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.issue.RapidViewIssue;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueKey;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.web.action.issue.IssueSearchLimits;
import com.atlassian.query.Query;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueResourceHelper {
    private static final Integer DEFAULT_ISSUES_RETURNED = 50;
    private final ResponseFactory responseFactory;
    private final BoardIssueBeanFactory boardIssueBeanFactory;
    private final IssueSearchLimits issueSearchLimits;
    private final BoardResourceHelper boardResourceHelper;
    private final SearchService searchService;
    private final IssueService issueService;

    @Autowired
    public IssueResourceHelper(ResponseFactory responseFactory, BoardIssueBeanFactory boardIssueBeanFactory, IssueSearchLimits issueSearchLimits, BoardResourceHelper boardResourceHelper, SearchService searchService, IssueService issueService) {
        this.responseFactory = responseFactory;
        this.boardIssueBeanFactory = boardIssueBeanFactory;
        this.issueSearchLimits = issueSearchLimits;
        this.boardResourceHelper = boardResourceHelper;
        this.searchService = searchService;
        this.issueService = issueService;
    }

    public Response searchIssueByQueryParams(ApplicationUser user, String jql, Boolean validateQuery, Long startAt, Integer maxResults, List<StringList> fields, String expand, IssueSearchAction issueSearchAction) {
        Query query;
        ServiceOutcome<Option<Query>> queryOutcome = this.queryFromJql(user, jql, validateQuery);
        if (!queryOutcome.isValid()) {
            return this.responseFactory.errorsToResponse(queryOutcome.getErrors());
        }
        PageRequest request = Requests.requestWithLimit(startAt, (Integer)MoreObjects.firstNonNull((Object)maxResults, (Object)DEFAULT_ISSUES_RETURNED), this.issueSearchLimits.getMaxResults());
        ServiceOutcome<Page<RapidViewIssue>> issues = issueSearchAction.apply(request, query = (Query)queryOutcome.get().getOrNull());
        if (!issues.isValid()) {
            return this.responseFactory.errorsToResponse(issues.getErrors());
        }
        return ResponseFactory.okNoCache(this.boardIssueBeanFactory.toBeans(issues.get(), fields, expand));
    }

    public Response searchIssueByQueryParamsForBoard(Long boardId, String jql, Boolean validateQuery, Long startAt, Integer maxResults, List<StringList> fields, String expand, BoardIssueSearchAction boardIssueSearchAction) {
        return this.boardResourceHelper.executeWithBoard(boardId, (user, rapidView) -> {
            IssueSearchAction issueSearchAction = (request, query) -> boardIssueSearchAction.apply(user, rapidView, request, query);
            return this.searchIssueByQueryParams(user, jql, validateQuery, startAt, maxResults, fields, expand, issueSearchAction);
        });
    }

    public ServiceOutcome<Issue> getIssueForKeyOrId(ApplicationUser user, String issueKeyOrId) {
        ServiceOutcome<Either<Long, IssueKey>> idOrKeyOutcome = IssueResourceHelper.getIssueIdOrKey(issueKeyOrId);
        if (!idOrKeyOutcome.isValid()) {
            return ServiceOutcomeImpl.error(idOrKeyOutcome);
        }
        IssueService.IssueResult issueResult = (IssueService.IssueResult)idOrKeyOutcome.get().fold(issueId -> this.issueService.getIssue(user, issueId), issueKey -> this.issueService.getIssue(user, issueKey.toString()));
        if (!issueResult.isValid()) {
            return ServiceOutcomeImpl.from(ErrorCollection.fromJiraErrorCollectionWithReasons(issueResult.getErrorCollection()));
        }
        MutableIssue issue = issueResult.getIssue();
        return ServiceOutcomeImpl.ok(issue);
    }

    public static ServiceOutcome<Either<Long, IssueKey>> getIssueIdOrKey(String issueIdOrKey) {
        return IssueResourceHelper.getIdOrKey(issueIdOrKey, "gh.error.issue.invalid.key");
    }

    public static ServiceOutcome<Either<Long, IssueKey>> getEpicIdOrKey(String epicIdOrKey) {
        return IssueResourceHelper.getIdOrKey(epicIdOrKey, "gh.epic.error.invalid.key");
    }

    private static ServiceOutcome<Either<Long, IssueKey>> getIdOrKey(String idOrKey, String errorKey) {
        try {
            Long id = Long.parseLong(idOrKey);
            return ServiceOutcomeImpl.ok(Either.left((Object)id));
        }
        catch (Exception ignored) {
            try {
                return ServiceOutcomeImpl.ok(Either.right((Object)IssueKey.from((String)idOrKey)));
            }
            catch (Exception e) {
                return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, errorKey, new Object[0]);
            }
        }
    }

    private ServiceOutcome<Option<Query>> queryFromJql(ApplicationUser user, @Nullable String jql, Boolean validateQuery) {
        if (jql == null) {
            return ServiceOutcomeImpl.ok(Option.none());
        }
        SearchService.ParseResult parseResult = this.searchService.parseQuery(user, jql);
        if (!parseResult.isValid()) {
            Set errors = parseResult.getErrors().getErrorMessages();
            return ServiceOutcomeImpl.from(IssueResourceHelper.errors(ErrorCollection.Reason.VALIDATION_FAILED, errors));
        }
        MessageSet result = this.searchService.validateQuery(user, parseResult.getQuery());
        if ((validateQuery == null || validateQuery.booleanValue()) && result.hasAnyErrors()) {
            ImmutableSet errors = ImmutableSet.builder().addAll((Iterable)result.getErrorMessages()).addAll((Iterable)result.getWarningMessages()).build();
            return ServiceOutcomeImpl.from(IssueResourceHelper.errors(ErrorCollection.Reason.VALIDATION_FAILED, (Set<String>)errors));
        }
        return ServiceOutcomeImpl.ok(Option.some((Object)parseResult.getQuery()));
    }

    private static ErrorCollection errors(ErrorCollection.Reason reason, Set<String> errors) {
        ErrorCollection errorCollection = new ErrorCollection();
        errorCollection.addReason(reason);
        for (String error : errors) {
            errorCollection.addError(error, new Object[0]);
        }
        return errorCollection;
    }

    public static interface BoardIssueSearchAction {
        public ServiceOutcome<Page<RapidViewIssue>> apply(ApplicationUser var1, RapidView var2, PageRequest var3, Query var4);
    }

    public static interface IssueSearchAction {
        public ServiceOutcome<Page<RapidViewIssue>> apply(PageRequest var1, Query var2);
    }
}

