/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest.util;

import com.atlassian.greenhopper.api.rest.util.ResponseFactory;
import com.atlassian.greenhopper.license.LicenseService;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BoardResourceHelper {
    private final RapidViewService rapidViewService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final LicenseService licenseService;
    private final ResponseFactory responseFactory;

    @Autowired
    public BoardResourceHelper(RapidViewService rapidViewService, JiraAuthenticationContext jiraAuthenticationContext, LicenseService licenseService, ResponseFactory responseFactory) {
        this.rapidViewService = rapidViewService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.licenseService = licenseService;
        this.responseFactory = responseFactory;
    }

    public Response executeWithBoard(Long boardId, WithBoardAction withBoardAction) {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        ServiceResult validateUser = this.licenseService.validateUser(user);
        if (!validateUser.isValid()) {
            return this.responseFactory.errorsToResponse(validateUser.getErrors());
        }
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, boardId);
        if (!rapidView.isValid()) {
            return this.responseFactory.errorsToResponse(rapidView.getErrors());
        }
        return withBoardAction.apply(user, rapidView.get());
    }

    public static interface WithBoardAction {
        public Response apply(ApplicationUser var1, RapidView var2);
    }
}

