/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest.bean.example;

import com.atlassian.greenhopper.api.rest.bean.RestDateFormatter;
import com.atlassian.greenhopper.api.rest.bean.SprintBean;
import com.atlassian.greenhopper.api.rest.bean.example.EpicBeanExample;
import com.atlassian.greenhopper.api.rest.bean.example.ExamplesUri;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.beans.CommentJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.WorklogJsonBean;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import com.atlassian.jira.rest.v2.issue.TimeTrackingBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectBean;
import com.atlassian.jira.rest.v2.search.SearchResultsBean;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class BoardIssueBeanExamples {
    public static final IssueBean EXAMPLE;
    public static final SearchResultsBean EXAMPLE_PAGE;

    private static void addField(IssueBean issueBean, String id, Object data) {
        SimpleField field = new SimpleField(id);
        issueBean.addField((Field)field, new FieldJsonRepresentation(new JsonData(data)), false);
    }

    static {
        SprintBean closedSprint = SprintBean.builder().id(37L).self(ExamplesUri.experimentalRestURI("sprint", "23")).name("sprint 1").state("closed").startDate(RestDateFormatter.formatDate(new DateTime(2015, 4, 11, 15, 22, DateTimeZone.forOffsetHours((int)10)))).endDate(RestDateFormatter.formatDate(new DateTime(2015, 4, 20, 1, 22, DateTimeZone.forOffsetHours((int)10)))).completeDate(RestDateFormatter.formatDate(new DateTime(2015, 4, 20, 11, 4, DateTimeZone.forOffsetHours((int)10)))).build();
        SprintBean futureSprint = SprintBean.builder().id(37L).self(ExamplesUri.experimentalRestURI("sprint", "13")).name("sprint 2").state("future").build();
        EXAMPLE = new IssueBean(Long.valueOf(10001L), "HSP-1", ExamplesUri.experimentalRestURI("board", "92", "issue", "10001"));
        BoardIssueBeanExamples.addField(EXAMPLE, "updated", new Date(1L));
        BoardIssueBeanExamples.addField(EXAMPLE, "description", "example bug report");
        BoardIssueBeanExamples.addField(EXAMPLE, "project", ProjectBean.SHORT_DOC_EXAMPLE_1);
        BoardIssueBeanExamples.addField(EXAMPLE, "timetracking", new TimeTrackingBean(Long.valueOf(600L), Long.valueOf(200L), Long.valueOf(400L)));
        BoardIssueBeanExamples.addField(EXAMPLE, "comment", ImmutableList.of((Object)CommentJsonBean.DOC_EXAMPLE));
        BoardIssueBeanExamples.addField(EXAMPLE, "worklog", ImmutableList.of((Object)WorklogJsonBean.DOC_EXAMPLE));
        BoardIssueBeanExamples.addField(EXAMPLE, "sprint", futureSprint);
        BoardIssueBeanExamples.addField(EXAMPLE, "closedSprints", ImmutableList.of((Object)closedSprint));
        BoardIssueBeanExamples.addField(EXAMPLE, "flagged", true);
        BoardIssueBeanExamples.addField(EXAMPLE, "epic", EpicBeanExample.EXAMPLE);
        EXAMPLE_PAGE = new SearchResultsBean(Integer.valueOf(0), Integer.valueOf(50), Integer.valueOf(1), (List)ImmutableList.of((Object)EXAMPLE));
    }

    public static class SimpleField
    implements Field {
        private final String id;

        SimpleField(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String getNameKey() {
            return this.id;
        }

        public String getName() {
            return this.id;
        }

        public int compareTo(@Nullable Object o) {
            return 1;
        }
    }
}

