/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest.bean;

import com.atlassian.greenhopper.api.rest.bean.SprintBean;
import com.atlassian.greenhopper.api.rest.bean.SprintCreateBean;
import com.atlassian.greenhopper.api.rest.util.ServiceOutcomeImpl;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.sprint.Sprint;
import io.atlassian.fugue.Option;
import org.joda.time.DateTime;
import org.springframework.stereotype.Component;

@Component
public class SprintBeanTransformer {
    public ServiceOutcome<Sprint> fromBeanForUpdate(SprintBean bean) {
        ServiceOutcome<Option<Sprint.State>> state = this.parseState(bean.getState());
        ServiceOutcome<Option<DateTime>> startDate = this.parseDate(bean.getStartDate());
        ServiceOutcome<Option<DateTime>> endDate = this.parseDate(bean.getEndDate());
        ErrorCollection errorCollection = new ErrorCollection();
        errorCollection.addAllErrors(state.getErrors());
        errorCollection.addAllErrors(startDate.getErrors());
        errorCollection.addAllErrors(endDate.getErrors());
        if (errorCollection.hasErrors()) {
            return ServiceOutcomeImpl.from(errorCollection);
        }
        return ServiceOutcomeImpl.ok(Sprint.builder().name(bean.getName()).state((Sprint.State)((Object)state.get().getOrNull())).startDate((DateTime)startDate.get().getOrNull()).endDate((DateTime)endDate.get().getOrNull()).goal(bean.getGoal()).build());
    }

    public ServiceOutcome<Sprint> fromBeanForCreate(SprintCreateBean bean) {
        ErrorCollection originBoardIdErrors = this.validateOriginBoardId(bean.getOriginBoardId());
        ServiceOutcome<Option<DateTime>> startDate = this.parseDate(bean.getStartDate());
        ServiceOutcome<Option<DateTime>> endDate = this.parseDate(bean.getEndDate());
        ErrorCollection errorCollection = new ErrorCollection();
        errorCollection.addAllErrors(originBoardIdErrors);
        errorCollection.addAllErrors(startDate.getErrors());
        errorCollection.addAllErrors(endDate.getErrors());
        if (errorCollection.hasErrors()) {
            return ServiceOutcomeImpl.from(errorCollection);
        }
        return ServiceOutcomeImpl.ok(Sprint.builder().name(bean.getName()).rapidViewId(bean.getOriginBoardId()).startDate((DateTime)startDate.get().getOrNull()).endDate((DateTime)endDate.get().getOrNull()).state(Sprint.State.FUTURE).goal(bean.getGoal()).build());
    }

    private ErrorCollection validateOriginBoardId(Long originBoardId) {
        if (originBoardId == null) {
            ErrorCollection errorCollection = new ErrorCollection();
            errorCollection.addError(ErrorCollection.Reason.VALIDATION_FAILED, "gh.sprint.error.origin.board.required", new Object[0]);
            return errorCollection;
        }
        return new ErrorCollection();
    }

    private ServiceOutcome<Option<DateTime>> parseDate(String date) {
        if (date == null) {
            return ServiceOutcomeImpl.ok(Option.none());
        }
        try {
            return ServiceOutcomeImpl.ok(Option.some((Object)DateTime.parse((String)date)));
        }
        catch (Exception e) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rest.validation.sprint.invalid.date", date);
        }
    }

    private ServiceOutcome<Option<Sprint.State>> parseState(String state) {
        if (state == null) {
            return ServiceOutcomeImpl.ok(Option.none());
        }
        try {
            return ServiceOutcomeImpl.ok(Option.some((Object)((Object)Sprint.State.valueOf(state.toUpperCase()))));
        }
        catch (IllegalArgumentException ex) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rest.validation.sprint.invalid.state", state);
        }
    }
}

