/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest.bean;

import com.atlassian.greenhopper.api.rest.bean.BeanFactory;
import com.atlassian.greenhopper.api.rest.bean.RestDateFormatter;
import com.atlassian.greenhopper.api.rest.bean.SelfLinkFactory;
import com.atlassian.greenhopper.api.rest.bean.SprintBean;
import com.atlassian.greenhopper.service.sprint.Sprint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class SprintBeanFactory
implements BeanFactory<Sprint, SprintBean> {
    private final SelfLinkFactory selfLinkFactory;

    @Autowired
    public SprintBeanFactory(SelfLinkFactory selfLinkFactory) {
        this.selfLinkFactory = selfLinkFactory;
    }

    @Override
    public SprintBean toBean(Sprint from) {
        return SprintBean.builder().id(from.getId()).self(this.selfLinkFactory.selfLink("sprint", from.getId().toString())).name(from.getName()).state(from.getState().toString().toLowerCase()).startDate(RestDateFormatter.formatDate(from.getStartDate())).endDate(RestDateFormatter.formatDate(from.getEndDate())).completeDate(RestDateFormatter.formatDate(from.getCompleteDate())).originBoardId(from.getRapidViewId()).goal(from.getGoal()).build();
    }
}

