/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest.bean;

import com.atlassian.greenhopper.api.rank.RankChange;
import com.atlassian.greenhopper.api.rank.RankChangesOutcome;
import com.atlassian.greenhopper.api.rank.Rankable;
import com.atlassian.greenhopper.api.rest.bean.PartialSuccessBean;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.util.ErrorCollection;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Component
public class PartialSuccessBeanFactory {
    public PartialSuccessBean toBean(RankChangesOutcome from, Iterable<Issue> issues) {
        final ImmutableMap issueMappedById = Maps.uniqueIndex(issues, (Function)new Function<Issue, Long>(){

            public Long apply(Issue input) {
                return input.getId();
            }
        });
        Iterable successfulChanges = Iterables.transform(from.getSuccessfulRankChanges(), (Function)new Function<RankChange, PartialSuccessBean.Entry>(){

            public PartialSuccessBean.Entry apply(RankChange rankChange) {
                String issueKey = ((Issue)issueMappedById.get((Object)rankChange.getIssueId())).getKey();
                return new PartialSuccessBean.Entry(rankChange.getIssueId(), issueKey, Response.Status.OK.getStatusCode(), null);
            }
        });
        Iterable unsuccessfulChanges = Iterables.transform(from.getErrorCollections().entrySet(), (Function)new Function<Map.Entry<Rankable, ErrorCollection>, PartialSuccessBean.Entry>(){

            public PartialSuccessBean.Entry apply(Map.Entry<Rankable, ErrorCollection> input) {
                ErrorCollection errorCollection = input.getValue();
                ImmutableList errors = ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)errorCollection.getErrorMessages(), errorCollection.getErrors().values()));
                ErrorCollection.Reason reason = ErrorCollection.Reason.getWorstReason((Collection)errorCollection.getReasons());
                String issueKey = ((Issue)issueMappedById.get((Object)input.getKey().getId())).getKey();
                return new PartialSuccessBean.Entry(input.getKey().getId(), issueKey, reason.getHttpStatusCode(), (List<String>)errors);
            }
        });
        ImmutableList statuses = ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)successfulChanges, (Iterable)unsuccessfulChanges));
        return new PartialSuccessBean((List<PartialSuccessBean.Entry>)statuses);
    }
}

