/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest.bean;

import com.atlassian.greenhopper.api.rest.util.IssueResourceHelper;
import com.atlassian.greenhopper.api.rest.util.ServiceOutcomeImpl;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Functions;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueListForBulkEditRetriever {
    public static final int ISSUES_TO_EDIT_LIMIT = 50;
    private final IssueResourceHelper issueResourceHelper;

    @Autowired
    public IssueListForBulkEditRetriever(IssueResourceHelper issueResourceHelper) {
        this.issueResourceHelper = issueResourceHelper;
    }

    public ServiceOutcome<Iterable<Issue>> retrieveIssuesFromKeysAndIds(final @Nullable ApplicationUser user, Iterable<String> issueKeyOrIdList) {
        if (issueKeyOrIdList == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.api.issues.required", new Object[0]);
        }
        if (Iterables.size(issueKeyOrIdList) > 50) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.api.issues.exceed.limit", 50);
        }
        ImmutableList issueOutcomes = ImmutableList.copyOf((Iterable)Iterables.transform(issueKeyOrIdList, (Function)new Function<String, ServiceOutcome<Issue>>(){

            public ServiceOutcome<Issue> apply(@Nullable String issueIdOrKey) {
                ServiceOutcome<Issue> issueOutcome = IssueListForBulkEditRetriever.this.issueResourceHelper.getIssueForKeyOrId(user, issueIdOrKey);
                if (issueOutcome.isValid()) {
                    return issueOutcome;
                }
                return ServiceOutcomeImpl.from(IssueListForBulkEditRetriever.this.addContextToErrors(issueIdOrKey, issueOutcome.getErrors()));
            }
        }));
        ErrorCollection issueErrors = (ErrorCollection)Functions.fold((BiFunction)new BiFunction<ErrorCollection, ServiceOutcome<Issue>, ErrorCollection>(){

            @Override
            public ErrorCollection apply(ErrorCollection errorCollection, ServiceOutcome<Issue> issueOutcome) {
                return errorCollection.addAllErrors(issueOutcome.getErrors());
            }
        }, (Object)new ErrorCollection(), (Iterable)issueOutcomes);
        if (issueErrors.hasErrors()) {
            return ServiceOutcomeImpl.from(issueErrors);
        }
        Iterable issues = Iterables.transform((Iterable)issueOutcomes, (Function)new Function<ServiceOutcome<Issue>, Issue>(){

            public Issue apply(ServiceOutcome<Issue> issueOutcome) {
                return issueOutcome.get();
            }
        });
        return ServiceOutcomeImpl.ok(issues);
    }

    private ErrorCollection addContextToErrors(String issueIdOrKey, ErrorCollection errors) {
        ErrorCollection newErrorCollection = new ErrorCollection();
        for (ErrorCollection.ErrorItem error : errors.getErrors()) {
            if (error.isContextualError()) {
                newErrorCollection.addContextualError(error.getContextId(), error.getMessageKey(), error.getParams());
                continue;
            }
            newErrorCollection.addContextualError(issueIdOrKey, error.getMessageKey(), error.getParams());
        }
        newErrorCollection.addReason(ErrorCollection.Reason.VALIDATION_FAILED);
        return newErrorCollection;
    }
}

