/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest.bean;

import com.atlassian.greenhopper.api.rest.bean.EpicBean;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
public class EpicUpdateBean {
    private String name;
    private String summary;
    private EpicBean.ColorBean color;
    private Boolean done;

    @JsonCreator
    public EpicUpdateBean(@JsonProperty(value="name") String name, @JsonProperty(value="summary") String summary, @JsonProperty(value="color") EpicBean.ColorBean color, @JsonProperty(value="done") Boolean done) {
        this.summary = summary;
        this.name = name;
        this.color = color;
        this.done = done;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getName() {
        return this.name;
    }

    public EpicBean.ColorBean getColor() {
        return this.color;
    }

    public Boolean isDone() {
        return this.done;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(EpicUpdateBean data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EpicUpdateBean epicBean = (EpicUpdateBean)o;
        return Objects.equal((Object)this.done, (Object)epicBean.done) && Objects.equal((Object)this.summary, (Object)epicBean.summary) && Objects.equal((Object)this.name, (Object)epicBean.name) && Objects.equal((Object)this.color, (Object)epicBean.color);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.summary, this.name, this.color, this.done});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("issueSummary", (Object)this.summary).add("epicName", (Object)this.name).add("epicColor", (Object)this.color).add("done", (Object)this.done).toString();
    }

    public static final class Builder {
        private String summary;
        private String name;
        private EpicBean.ColorBean color;
        private Boolean done;

        private Builder() {
        }

        private Builder(EpicUpdateBean initialData) {
            this.summary = initialData.summary;
            this.name = initialData.name;
            this.color = initialData.color;
            this.done = initialData.done;
        }

        public Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder color(EpicBean.ColorBean color) {
            this.color = color;
            return this;
        }

        public Builder done(Boolean done) {
            this.done = done;
            return this;
        }

        public EpicUpdateBean build() {
            return new EpicUpdateBean(this.name, this.summary, this.color, this.done);
        }
    }
}

