/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest.bean;

import com.atlassian.greenhopper.api.rank.RankService;
import com.atlassian.greenhopper.api.rest.bean.EpicRankRequestBean;
import com.atlassian.greenhopper.api.rest.util.IssueResourceHelper;
import com.atlassian.greenhopper.api.rest.util.ServiceOutcomeImpl;
import com.atlassian.greenhopper.model.Epic;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.issuelink.EpicService;
import com.atlassian.jira.issue.IssueKey;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.user.ApplicationUser;
import io.atlassian.fugue.Either;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EpicRankRequestBeanValidator {
    private final RankService rankService;
    private final EpicService epicService;

    @Autowired
    public EpicRankRequestBeanValidator(RankService rankService, EpicService epicService) {
        this.rankService = rankService;
        this.epicService = epicService;
    }

    public ServiceOutcome<ValidRankRequest> validateRankRequest(@Nullable ApplicationUser user, EpicRankRequestBean epicRankRequestBean) {
        boolean bothRankBeforeAndAfterAreDefined;
        boolean noIssueRankBeforeOrAfter = epicRankRequestBean.getRankBeforeEpic() == null && epicRankRequestBean.getRankAfterEpic() == null;
        boolean bl = bothRankBeforeAndAfterAreDefined = epicRankRequestBean.getRankBeforeEpic() != null && epicRankRequestBean.getRankAfterEpic() != null;
        if (noIssueRankBeforeOrAfter || bothRankBeforeAndAfterAreDefined) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.api.rank.epics.error.before.or.after.required", new Object[0]);
        }
        ServiceOutcome<Long> rankFieldId = this.getRankFieldId(epicRankRequestBean.getRankCustomFieldId());
        if (!rankFieldId.isValid()) {
            return ServiceOutcomeImpl.from(this.notFoundToValidationFailed(rankFieldId.getErrors()));
        }
        ServiceOutcome<Epic> positionEpic = this.getRankToEpic(user, epicRankRequestBean);
        if (!positionEpic.isValid()) {
            return ServiceOutcomeImpl.from(this.notFoundToValidationFailed(positionEpic.getErrors()));
        }
        boolean isRankBefore = epicRankRequestBean.getRankBeforeEpic() != null;
        return ServiceOutcomeImpl.ok(new ValidRankRequest(positionEpic.get(), rankFieldId.get(), isRankBefore));
    }

    private ServiceOutcome<Epic> getRankToEpic(ApplicationUser user, EpicRankRequestBean epicRankRequestBean) {
        if (epicRankRequestBean.getRankAfterEpic() == null) {
            return this.getEpicForKeyOrId(user, epicRankRequestBean.getRankBeforeEpic());
        }
        return this.getEpicForKeyOrId(user, epicRankRequestBean.getRankAfterEpic());
    }

    private ServiceOutcome<Epic> getEpicForKeyOrId(ApplicationUser user, String epicIdOrKey) {
        ServiceOutcome<Either<Long, IssueKey>> idOrKey = IssueResourceHelper.getEpicIdOrKey(epicIdOrKey);
        return (ServiceOutcome)idOrKey.get().fold(epicId -> this.epicService.getEpic(user, (Long)epicId), epicKey -> this.epicService.getEpic(user, epicKey.toString()));
    }

    private ServiceOutcome<Long> getRankFieldId(@Nullable Long rankFieldId) {
        if (rankFieldId == null) {
            ServiceOutcome<CustomField> defaultRankField = ServiceOutcomeImpl.from(this.rankService.getDefaultRankField());
            if (defaultRankField.isValid()) {
                return ServiceOutcomeImpl.ok(defaultRankField.get().getIdAsLong());
            }
            return ServiceOutcomeImpl.error(defaultRankField);
        }
        if (!this.rankService.isRankField(rankFieldId)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.api.rank.error.custom.field.not.found", rankFieldId);
        }
        return ServiceOutcomeImpl.ok(rankFieldId);
    }

    private ErrorCollection notFoundToValidationFailed(ErrorCollection errorCollection) {
        if (!errorCollection.getDefinitiveReason().equals((Object)ErrorCollection.Reason.NOT_FOUND)) {
            return errorCollection;
        }
        ErrorCollection newErrorCollection = new ErrorCollection();
        newErrorCollection.addAllErrorsWithoutReason(errorCollection);
        newErrorCollection.addReason(ErrorCollection.Reason.VALIDATION_FAILED);
        return newErrorCollection;
    }

    public static class ValidRankRequest {
        private final Epic positionEpic;
        private final Long rankCustomFieldId;
        private final boolean isRankBefore;

        private ValidRankRequest(Epic positionEpic, Long rankCustomFieldId, boolean isRankBefore) {
            this.positionEpic = positionEpic;
            this.rankCustomFieldId = rankCustomFieldId;
            this.isRankBefore = isRankBefore;
        }

        public Epic getPositionEpic() {
            return this.positionEpic;
        }

        public boolean isRankBefore() {
            return this.isRankBefore;
        }

        public Long getRankCustomFieldId() {
            return this.rankCustomFieldId;
        }
    }
}

