/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest.bean;

import com.atlassian.greenhopper.api.rest.bean.BeanFactory;
import com.atlassian.greenhopper.api.rest.bean.EpicBean;
import com.atlassian.greenhopper.api.rest.bean.SelfLinkFactory;
import com.atlassian.greenhopper.model.Epic;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EpicBeanFactory
implements BeanFactory<Epic, EpicBean> {
    private final SelfLinkFactory selfLinkFactory;

    @Autowired
    public EpicBeanFactory(SelfLinkFactory selfLinkFactory) {
        this.selfLinkFactory = selfLinkFactory;
    }

    @Override
    public EpicBean toBean(Epic from) {
        return EpicBean.builder().id(from.getId()).key(from.getKey()).self(this.selfLinkFactory.selfLink("epic", from.getId().toString())).summary(from.getSummary()).name(from.getName()).color(this.getColorBean(from)).done(from.isDone()).build();
    }

    private EpicBean.ColorBean getColorBean(Epic from) {
        Option<EpicBean.ColorKey> colorKey = EpicBean.ColorKey.getFromStrignKey(from.getColorKey());
        return new EpicBean.ColorBean((EpicBean.ColorKey)((Object)colorKey.getOrElse((Object)EpicBean.ColorKey.color_1)));
    }
}

