/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest.bean;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import java.net.URI;
import java.util.Arrays;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class EpicBean {
    private final Long id;
    private final String key;
    private final URI self;
    private final String name;
    private final String summary;
    private final ColorBean color;
    private final boolean done;

    public EpicBean(Long id, String key, URI self, String name, String summary, ColorBean color, boolean done) {
        this.id = id;
        this.key = key;
        this.self = self;
        this.summary = summary;
        this.name = name;
        this.color = color;
        this.done = done;
    }

    public Long getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public URI getSelf() {
        return this.self;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getName() {
        return this.name;
    }

    public ColorBean getColor() {
        return this.color;
    }

    public boolean isDone() {
        return this.done;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(EpicBean data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EpicBean epicBean = (EpicBean)o;
        return Objects.equal((Object)this.done, (Object)epicBean.done) && Objects.equal((Object)this.id, (Object)epicBean.id) && Objects.equal((Object)this.key, (Object)epicBean.key) && Objects.equal((Object)this.self, (Object)epicBean.self) && Objects.equal((Object)this.summary, (Object)epicBean.summary) && Objects.equal((Object)this.name, (Object)epicBean.name) && Objects.equal((Object)this.color, (Object)epicBean.color);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.key, this.self, this.summary, this.name, this.color, this.done});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("issueId", (Object)this.id).add("issueKey", (Object)this.key).add("self", (Object)this.self).add("issueSummary", (Object)this.summary).add("epicName", (Object)this.name).add("epicColor", (Object)this.color).add("done", this.done).toString();
    }

    @JsonAutoDetect
    public static class ColorBean {
        private ColorKey key;

        public ColorBean() {
        }

        public ColorBean(ColorKey key) {
            this.key = key;
        }

        public ColorKey getKey() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColorBean colorBean = (ColorBean)o;
            return Objects.equal((Object)((Object)this.key), (Object)((Object)colorBean.key));
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.key});
        }
    }

    public static enum ColorKey {
        color_1("ghx-label-1"),
        color_2("ghx-label-2"),
        color_3("ghx-label-3"),
        color_4("ghx-label-4"),
        color_5("ghx-label-5"),
        color_6("ghx-label-6"),
        color_7("ghx-label-7"),
        color_8("ghx-label-8"),
        color_9("ghx-label-9"),
        color_10("ghx-label-10"),
        color_11("ghx-label-11"),
        color_12("ghx-label-12"),
        color_13("ghx-label-13"),
        color_14("ghx-label-14");

        private final String key;

        private ColorKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        static Option<ColorKey> getFromStrignKey(String key) {
            return Iterables.findFirst(Arrays.asList(ColorKey.class.getEnumConstants()), colorKey -> colorKey.getKey().equals(key));
        }
    }

    public static final class Builder {
        private Long id;
        private URI self;
        private String key;
        private String summary;
        private String name;
        private ColorBean color;
        private boolean done;

        private Builder() {
        }

        private Builder(EpicBean initialData) {
            this.id = initialData.id;
            this.self = initialData.self;
            this.key = initialData.key;
            this.summary = initialData.summary;
            this.name = initialData.name;
            this.color = initialData.color;
            this.done = initialData.done;
        }

        public Builder id(Long id) {
            this.id = id;
            return this;
        }

        public Builder self(URI self) {
            this.self = self;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder color(ColorBean color) {
            this.color = color;
            return this;
        }

        public Builder done(Boolean done) {
            this.done = done;
            return this;
        }

        public EpicBean build() {
            return new EpicBean(this.id, this.key, this.self, this.name, this.summary, this.color, this.done);
        }
    }
}

