/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest.bean;

import com.atlassian.greenhopper.api.rest.bean.BoardConfigBean;
import com.atlassian.greenhopper.api.rest.bean.BoardConfigBeanColumnUtils;
import com.atlassian.greenhopper.api.rest.bean.SelfLinkFactory;
import com.atlassian.greenhopper.api.rest.bean.SubqueryBean;
import com.atlassian.greenhopper.model.rapid.ColumnConfig;
import com.atlassian.greenhopper.model.rapid.EstimationConfig;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.subquery.Subquery;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.v2.search.FilterResource;
import java.net.URI;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BoardConfigBeanFactory {
    private final SelfLinkFactory selfLinkFactory;
    private final JiraBaseUrls jiraBaseUrls;
    private final BoardConfigBeanColumnUtils boardConfigBeanColumnUtils;

    @Autowired
    public BoardConfigBeanFactory(SelfLinkFactory selfLinkFactory, JiraBaseUrls jiraBaseUrls, BoardConfigBeanColumnUtils boardConfigBeanColumnUtils) {
        this.selfLinkFactory = selfLinkFactory;
        this.jiraBaseUrls = jiraBaseUrls;
        this.boardConfigBeanColumnUtils = boardConfigBeanColumnUtils;
    }

    public BoardConfigBean toBean(RapidView board, @Nullable Long rankFieldId, ColumnConfig columnConfig, @Nullable EstimationConfig estimationConfig, @Nullable Subquery subquery) {
        URI configSelf = this.selfLinkFactory.selfLink("board", board.getId().toString(), "configuration");
        return BoardConfigBean.builder().id(board.getId()).name(board.getName()).type(board.getType().toString().toLowerCase()).self(configSelf).filter(this.createFilterBean(board.getSavedFilterId())).subQuery(this.toSubqueryBean(subquery)).columnConfig(this.boardConfigBeanColumnUtils.createColumnConfigBean(columnConfig)).estimation(this.boardConfigBeanColumnUtils.createEstimationConfigBean(estimationConfig)).ranking(this.createRankingConfigBean(rankFieldId)).build();
    }

    private SubqueryBean toSubqueryBean(@Nullable Subquery subquery) {
        if (subquery == null) {
            return null;
        }
        return new SubqueryBean(subquery.getQuery());
    }

    private BoardConfigBean.RankingConfigBean createRankingConfigBean(Long rankFieldId) {
        return new BoardConfigBean.RankingConfigBean(rankFieldId);
    }

    private BoardConfigBean.RelationBean createFilterBean(Long filterId) {
        URI self = UriBuilder.fromPath((String)this.jiraBaseUrls.restApi2BaseUrl()).path(FilterResource.class).path(Long.toString(filterId)).build(new Object[0]);
        return new BoardConfigBean.RelationBean(Long.toString(filterId), self);
    }
}

