/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest.bean;

import com.atlassian.greenhopper.api.rest.bean.SubqueryBean;
import java.net.URI;
import java.util.List;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class BoardConfigBean {
    private final Long id;
    private final String name;
    private final String type;
    private final URI self;
    private final RelationBean filter;
    private final SubqueryBean subQuery;
    private final ColumnConfigBean columnConfig;
    private final EstimationConfigBean estimation;
    private final RankingConfigBean ranking;

    private BoardConfigBean(Long id, String name, String type, URI self, RelationBean filter, SubqueryBean subQuery, ColumnConfigBean columnConfig, EstimationConfigBean estimation, RankingConfigBean ranking) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.self = self;
        this.filter = filter;
        this.subQuery = subQuery;
        this.columnConfig = columnConfig;
        this.estimation = estimation;
        this.ranking = ranking;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public URI getSelf() {
        return this.self;
    }

    public RelationBean getFilter() {
        return this.filter;
    }

    public SubqueryBean getSubQuery() {
        return this.subQuery;
    }

    public ColumnConfigBean getColumnConfig() {
        return this.columnConfig;
    }

    public EstimationConfigBean getEstimation() {
        return this.estimation;
    }

    public RankingConfigBean getRanking() {
        return this.ranking;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonAutoDetect
    public static class RankingConfigBean {
        private final Long rankCustomFieldId;

        public RankingConfigBean(Long rankCustomFieldId) {
            this.rankCustomFieldId = rankCustomFieldId;
        }

        public Long getRankCustomFieldId() {
            return this.rankCustomFieldId;
        }
    }

    @JsonAutoDetect
    public static class EstimationFieldBean {
        private final String fieldId;
        private final String displayName;

        public EstimationFieldBean(String fieldId, String displayName) {
            this.fieldId = fieldId;
            this.displayName = displayName;
        }

        public String getFieldId() {
            return this.fieldId;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    @JsonAutoDetect
    public static class EstimationConfigBean {
        private final String type;
        private final EstimationFieldBean field;

        public EstimationConfigBean(String type, EstimationFieldBean field) {
            this.type = type;
            this.field = field;
        }

        public String getType() {
            return this.type;
        }

        public EstimationFieldBean getField() {
            return this.field;
        }
    }

    @JsonAutoDetect
    public static class ColumnBean {
        private final String name;
        private final List<RelationBean> statuses;
        private final Integer min;
        private final Integer max;

        public ColumnBean(String name, List<RelationBean> statuses, Integer min, Integer max) {
            this.name = name;
            this.statuses = statuses;
            this.min = min;
            this.max = max;
        }

        public String getName() {
            return this.name;
        }

        public List<RelationBean> getStatuses() {
            return this.statuses;
        }

        public Integer getMin() {
            return this.min;
        }

        public Integer getMax() {
            return this.max;
        }
    }

    @JsonAutoDetect
    public static class ColumnConfigBean {
        private final List<ColumnBean> columns;
        private final String constraintType;

        public ColumnConfigBean(List<ColumnBean> columns, String constraintType) {
            this.columns = columns;
            this.constraintType = constraintType;
        }

        public String getConstraintType() {
            return this.constraintType;
        }

        public List<ColumnBean> getColumns() {
            return this.columns;
        }
    }

    @JsonAutoDetect
    public static class RelationBean {
        private final String id;
        private final URI self;

        public RelationBean(String id, URI self) {
            this.id = id;
            this.self = self;
        }

        public String getId() {
            return this.id;
        }

        public URI getSelf() {
            return this.self;
        }
    }

    public static final class Builder {
        private Long id;
        private String name;
        private String type;
        private URI self;
        private RelationBean filter;
        private ColumnConfigBean columnConfig;
        private EstimationConfigBean estimation;
        private RankingConfigBean ranking;
        private SubqueryBean subquery;

        private Builder() {
        }

        public Builder id(Long id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder self(URI self) {
            this.self = self;
            return this;
        }

        public Builder filter(RelationBean filter) {
            this.filter = filter;
            return this;
        }

        public Builder subQuery(SubqueryBean subquery) {
            this.subquery = subquery;
            return this;
        }

        public Builder columnConfig(ColumnConfigBean columns) {
            this.columnConfig = columns;
            return this;
        }

        public Builder estimation(EstimationConfigBean estimation) {
            this.estimation = estimation;
            return this;
        }

        public Builder ranking(RankingConfigBean ranking) {
            this.ranking = ranking;
            return this;
        }

        public BoardConfigBean build() {
            return new BoardConfigBean(this.id, this.name, this.type, this.self, this.filter, this.subquery, this.columnConfig, this.estimation, this.ranking);
        }
    }
}

