/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest.bean;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.net.URI;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public final class BoardBean {
    private final Long id;
    private final URI self;
    private final String name;
    private final String type;

    private BoardBean(Long id, URI self, String name, String type) {
        this.id = id;
        this.self = self;
        this.name = name;
        this.type = type;
    }

    public Long getId() {
        return this.id;
    }

    public URI getSelf() {
        return this.self;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BoardBean data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoardBean that = (BoardBean)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.self, (Object)that.self) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.type, (Object)that.type);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.self, this.name, this.type});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("self", (Object)this.self).add("name", (Object)this.name).add("type", (Object)this.type).toString();
    }

    public static final class Builder {
        private Long id;
        private URI self;
        private String name;
        private String type;
        private Long filterId;

        private Builder() {
        }

        private Builder(BoardBean initialData) {
            this.id = initialData.id;
            this.self = initialData.self;
            this.name = initialData.name;
            this.type = initialData.type;
        }

        public Builder id(Long id) {
            this.id = id;
            return this;
        }

        public Builder self(URI self) {
            this.self = self;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder filterId(Long filterId) {
            this.filterId = filterId;
            return this;
        }

        public BoardBean build() {
            return new BoardBean(this.id, this.self, this.name, this.type);
        }
    }
}

