/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest;

import com.atlassian.greenhopper.api.rest.bean.IssueAssignRequestBean;
import com.atlassian.greenhopper.api.rest.bean.IssueListForBulkEditRetriever;
import com.atlassian.greenhopper.api.rest.bean.SprintBean;
import com.atlassian.greenhopper.api.rest.bean.SprintBeanFactory;
import com.atlassian.greenhopper.api.rest.bean.SprintBeanTransformer;
import com.atlassian.greenhopper.api.rest.bean.SprintCreateBean;
import com.atlassian.greenhopper.api.rest.bean.SprintSwapBean;
import com.atlassian.greenhopper.api.rest.util.IssueResourceHelper;
import com.atlassian.greenhopper.api.rest.util.ResponseFactory;
import com.atlassian.greenhopper.license.LicenseService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.issue.RapidViewIssueService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintIssueService;
import com.atlassian.greenhopper.service.sprint.SprintService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="sprint")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public final class SprintResource {
    private final SprintService sprintService;
    private final SprintBeanFactory sprintBeanFactory;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final LicenseService licenseService;
    private final ResponseFactory responseFactory;
    private final SprintBeanTransformer sprintBeanTransformer;
    private final IssueResourceHelper issueResourceHelper;
    private final SprintIssueService sprintIssueService;
    private final RapidViewIssueService rapidViewIssueService;
    private final IssueListForBulkEditRetriever issueListForBulkEditRetriever;

    public SprintResource(SprintService sprintService, SprintBeanFactory sprintBeanFactory, JiraAuthenticationContext jiraAuthenticationContext, LicenseService licenseService, ResponseFactory responseFactory, SprintBeanTransformer sprintBeanTransformer, IssueResourceHelper issueResourceHelper, SprintIssueService sprintIssueService, RapidViewIssueService rapidViewIssueService, IssueListForBulkEditRetriever issueListForBulkEditRetriever) {
        this.sprintService = sprintService;
        this.sprintBeanFactory = sprintBeanFactory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.licenseService = licenseService;
        this.responseFactory = responseFactory;
        this.sprintBeanTransformer = sprintBeanTransformer;
        this.issueResourceHelper = issueResourceHelper;
        this.sprintIssueService = sprintIssueService;
        this.rapidViewIssueService = rapidViewIssueService;
        this.issueListForBulkEditRetriever = issueListForBulkEditRetriever;
    }

    @GET
    @Path(value="{sprintId}")
    public Response getSprint(@PathParam(value="sprintId") Long sprintId) {
        return this.executeWithSprint(sprintId, (user, sprint) -> ResponseFactory.okNoCache(this.sprintBeanFactory.toBean(sprint)));
    }

    @POST
    public Response createSprint(SprintCreateBean sprintBean) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        ServiceResult validateUser = this.licenseService.validateUser(user);
        if (!validateUser.isValid()) {
            return this.responseFactory.errorsToResponse(validateUser.getErrors());
        }
        ServiceOutcome<Sprint> sprintToCreate = this.sprintBeanTransformer.fromBeanForCreate(sprintBean);
        if (sprintToCreate.isInvalid()) {
            return this.responseFactory.errorsToResponse(sprintToCreate.getErrors());
        }
        ServiceOutcome<Sprint> createdSprint = this.sprintService.createSprint(user, sprintToCreate.get());
        if (!createdSprint.isValid()) {
            return this.responseFactory.errorsToResponse(createdSprint.getErrors());
        }
        SprintBean createdSprintBean = this.sprintBeanFactory.toBean(createdSprint.get());
        return ResponseFactory.created(createdSprintBean.getSelf(), createdSprintBean);
    }

    @PUT
    @Path(value="{sprintId}")
    public Response updateSprint(@PathParam(value="sprintId") Long sprintId, SprintBean sprintBean) {
        return this.updateSprint(sprintId, sprintBean, (originalSprint, userInput) -> Sprint.builder(originalSprint).name(userInput.getName()).startDate(userInput.getStartDate()).endDate(userInput.getEndDate()).state(userInput.getState()).goal(userInput.getGoal()).build());
    }

    @POST
    @Path(value="{sprintId}")
    public Response partiallyUpdateSprint(@PathParam(value="sprintId") Long sprintId, SprintBean sprintBean) {
        return this.updateSprint(sprintId, sprintBean, (originalSprint, userInput) -> {
            Object goal = userInput.getGoal() == null ? originalSprint.getGoal() : (StringUtils.isBlank((CharSequence)userInput.getGoal()) ? null : userInput.getGoal());
            Sprint.SprintBuilder updated = Sprint.builder(originalSprint).name(Optional.ofNullable(userInput.getName()).orElse(originalSprint.getName())).startDate(Optional.ofNullable(userInput.getStartDate()).orElse(originalSprint.getStartDate())).endDate(Optional.ofNullable(userInput.getEndDate()).orElse(originalSprint.getEndDate())).state(Optional.ofNullable(userInput.getState()).orElse(originalSprint.getState())).goal((String)goal);
            return updated.build();
        });
    }

    @DELETE
    @Path(value="{sprintId}")
    public Response deleteSprint(@PathParam(value="sprintId") Long sprintId) {
        return this.executeWithSprint(sprintId, (user, sprint) -> {
            ServiceResult serviceResult = this.sprintService.deleteSprint(user, sprint, null);
            return serviceResult.isValid() ? ResponseFactory.noContent() : this.responseFactory.errorsToResponse(serviceResult.getErrors());
        });
    }

    @GET
    @Path(value="{sprintId}/issue")
    public Response getIssuesForSprint(@PathParam(value="sprintId") Long sprintId, @QueryParam(value="startAt") Long startAt, @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="jql") String jql, @QueryParam(value="validateQuery") Boolean validateQuery, @QueryParam(value="fields") List<StringList> fields, @QueryParam(value="expand") String expand) {
        return this.executeWithSprint(sprintId, (user, sprint) -> this.issueResourceHelper.searchIssueByQueryParams(user, jql, validateQuery, startAt, maxResults, fields, expand, (pageRequest, query) -> this.rapidViewIssueService.getIssuesForSprint(user, sprint, pageRequest, query)));
    }

    @POST
    @Path(value="{sprintId}/issue")
    public Response moveIssuesToSprint(@PathParam(value="sprintId") Long sprintId, IssueAssignRequestBean issueAssignRequestBean) {
        return this.executeWithSprint(sprintId, (user, sprint) -> {
            ServiceOutcome<Iterable<Issue>> issues = this.issueListForBulkEditRetriever.retrieveIssuesFromKeysAndIds(user, issueAssignRequestBean.getIssues());
            if (!issues.isValid()) {
                return this.responseFactory.errorsToResponse(issues.getErrors());
            }
            ServiceResult issueAssignmentResult = this.sprintIssueService.moveIssuesToSprint(user, sprint, (Collection<Issue>)ImmutableList.copyOf(issues.get()));
            if (!issueAssignmentResult.isValid()) {
                return this.responseFactory.errorsToResponse(issueAssignmentResult.getErrors());
            }
            return ResponseFactory.noContent();
        });
    }

    @POST
    @Path(value="{sprintId}/swap")
    public Response swapSprint(@PathParam(value="sprintId") Long sprintId, SprintSwapBean sprintSwapBean) {
        return this.executeWithSprint(sprintId, (user, sprint1) -> this.executeWithSprint(sprintSwapBean.getSprintToSwapWith(), (user1, sprint2) -> {
            ServiceResult swapResult = this.sprintService.swapSprints(user, sprint1, sprint2);
            if (swapResult.isInvalid()) {
                return this.responseFactory.errorsToResponse(swapResult.getErrors());
            }
            return ResponseFactory.noContent();
        }));
    }

    private Response updateSprint(Long sprintId, SprintBean userInput, RewriteSprintFields fieldRewriteFunction) {
        return this.executeWithSprint(sprintId, (user, originalSprint) -> {
            ServiceOutcome<Sprint> sprintInput = this.sprintBeanTransformer.fromBeanForUpdate(userInput);
            if (!sprintInput.isValid()) {
                return this.responseFactory.errorsToResponse(sprintInput.getErrors());
            }
            Sprint sprintToUpdate = fieldRewriteFunction.rewrite(originalSprint, sprintInput.get());
            ServiceOutcome<Sprint> updatedSprint = this.sprintService.updateSprint(user, sprintToUpdate);
            if (!updatedSprint.isValid()) {
                return this.responseFactory.errorsToResponse(updatedSprint.getErrors());
            }
            return ResponseFactory.okNoCache(this.sprintBeanFactory.toBean(updatedSprint.get()));
        });
    }

    public Response executeWithSprint(Long sprintId, WithSprintAction withSprintAction) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        ServiceResult validateUser = this.licenseService.validateUser(user);
        if (!validateUser.isValid()) {
            return this.responseFactory.errorsToResponse(validateUser.getErrors());
        }
        ServiceOutcome<Sprint> sprint = this.sprintService.getSprint(user, sprintId);
        if (!sprint.isValid()) {
            return this.responseFactory.errorsToResponse(sprint.getErrors());
        }
        return withSprintAction.apply(user, sprint.get());
    }

    private static interface RewriteSprintFields {
        public Sprint rewrite(Sprint var1, Sprint var2);
    }

    public static interface WithSprintAction {
        public Response apply(ApplicationUser var1, Sprint var2);
    }
}

