/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest;

import com.atlassian.greenhopper.api.rank.RankChangesOutcome;
import com.atlassian.greenhopper.api.rank.RankService;
import com.atlassian.greenhopper.api.rest.bean.BoardIssueBeanFactory;
import com.atlassian.greenhopper.api.rest.bean.FieldEditBean;
import com.atlassian.greenhopper.api.rest.bean.FieldValueBean;
import com.atlassian.greenhopper.api.rest.bean.IssueRankRequestBean;
import com.atlassian.greenhopper.api.rest.bean.IssueRankRequestBeanValidator;
import com.atlassian.greenhopper.api.rest.bean.PartialSuccessBeanFactory;
import com.atlassian.greenhopper.api.rest.util.IssueResourceHelper;
import com.atlassian.greenhopper.api.rest.util.ResponseFactory;
import com.atlassian.greenhopper.api.rest.util.ServiceOutcomeImpl;
import com.atlassian.greenhopper.license.LicenseService;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.issue.FieldValue;
import com.atlassian.greenhopper.service.issue.RapidViewIssue;
import com.atlassian.greenhopper.service.issue.RapidViewIssueService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueKey;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserIssueHistoryManager;
import io.atlassian.fugue.Either;
import java.util.List;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="issue")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class IssueResource {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final LicenseService licenseService;
    private final ResponseFactory responseFactory;
    private final RapidViewIssueService rapidViewIssueService;
    private final BoardIssueBeanFactory boardIssueBeanFactory;
    private final RankService rankService;
    private final PartialSuccessBeanFactory partialSuccessBeanFactory;
    private final IssueRankRequestBeanValidator issueRankRequestBeanValidator;
    private final RapidViewService rapidViewService;
    private final UserIssueHistoryManager userIssueHistoryManager;

    public IssueResource(JiraAuthenticationContext jiraAuthenticationContext, LicenseService licenseService, ResponseFactory responseFactory, RapidViewIssueService rapidViewIssueService, BoardIssueBeanFactory boardIssueBeanFactory, RankService rankService, PartialSuccessBeanFactory partialSuccessBeanFactory, IssueRankRequestBeanValidator issueRankRequestBeanValidator, RapidViewService rapidViewService, UserIssueHistoryManager userIssueHistoryManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.licenseService = licenseService;
        this.responseFactory = responseFactory;
        this.rapidViewIssueService = rapidViewIssueService;
        this.boardIssueBeanFactory = boardIssueBeanFactory;
        this.rankService = rankService;
        this.partialSuccessBeanFactory = partialSuccessBeanFactory;
        this.issueRankRequestBeanValidator = issueRankRequestBeanValidator;
        this.rapidViewService = rapidViewService;
        this.userIssueHistoryManager = userIssueHistoryManager;
    }

    @GET
    @Path(value="{issueIdOrKey}")
    public Response getIssue(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="fields") List<StringList> fields, @QueryParam(value="expand") String expand, @QueryParam(value="updateHistory") boolean updateHistory) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        ServiceResult validateUser = this.licenseService.validateUser(user);
        if (!validateUser.isValid()) {
            return this.responseFactory.errorsToResponse(validateUser.getErrors());
        }
        ServiceOutcome<Either<Long, IssueKey>> idOrKey = IssueResourceHelper.getIssueIdOrKey(issueIdOrKey);
        if (!idOrKey.isValid()) {
            return this.responseFactory.errorsToResponse(idOrKey.getErrors());
        }
        ServiceOutcome<RapidViewIssue> issue = this.getRapidViewIssueFromIdOrKey(user, issueIdOrKey);
        if (!issue.isValid()) {
            return this.responseFactory.errorsToResponse(issue.getErrors());
        }
        RapidViewIssue rapidViewIssue = issue.get();
        if (updateHistory && user != null) {
            this.userIssueHistoryManager.addIssueToHistory(user, rapidViewIssue.getIssue());
        }
        return ResponseFactory.okNoCache(this.boardIssueBeanFactory.toBean(rapidViewIssue, fields, expand));
    }

    @PUT
    @Path(value="rank")
    public Response rankIssues(IssueRankRequestBean issueRankRequestBean) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        ServiceResult validateUser = this.licenseService.validateUser(user);
        if (!validateUser.isValid()) {
            return this.responseFactory.errorsToResponse(validateUser.getErrors());
        }
        ServiceOutcome<IssueRankRequestBeanValidator.ValidRankRequest> validIssueRankRequestOutcome = this.issueRankRequestBeanValidator.validateRankRequest(user, issueRankRequestBean);
        if (!validIssueRankRequestOutcome.isValid()) {
            return this.responseFactory.errorsToResponse(validIssueRankRequestOutcome.getErrors());
        }
        IssueRankRequestBeanValidator.ValidRankRequest validRankRequest = validIssueRankRequestOutcome.get();
        ServiceOutcome<RankChangesOutcome> rankChangesOutcome = this.rankIssues(validRankRequest, user);
        if (!rankChangesOutcome.isValid()) {
            return this.responseFactory.errorsToResponse(rankChangesOutcome.getErrors());
        }
        RankChangesOutcome rankChanges = rankChangesOutcome.get();
        if (rankChanges.getErrorCollections().isEmpty()) {
            return ResponseFactory.noContent();
        }
        return ResponseFactory.multiResponseNoCache(this.partialSuccessBeanFactory.toBean(rankChanges, validRankRequest.getIssues()));
    }

    private ServiceOutcome<RankChangesOutcome> rankIssues(IssueRankRequestBeanValidator.ValidRankRequest validRankRequest, ApplicationUser user) {
        Long rankFieldId = validRankRequest.getRankCustomFieldId();
        List<Issue> issues = validRankRequest.getIssues();
        Issue rankToIssue = validRankRequest.getPositionIssue();
        if (validRankRequest.isRankBefore()) {
            return ServiceOutcomeImpl.from(this.rankService.rankBefore(user, (long)rankFieldId, issues, rankToIssue));
        }
        return ServiceOutcomeImpl.from(this.rankService.rankAfter(user, (long)rankFieldId, issues, rankToIssue));
    }

    @GET
    @Path(value="{issueIdOrKey}/estimation")
    public Response getIssueEstimationForBoard(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="boardId") Long boardId) {
        ServiceOutcome issueEstimationForBoard = this.doOperationInUserBoardIssueContext(boardId, issueIdOrKey, (user, rapidView, issue) -> this.rapidViewIssueService.getIssueEstimationForBoard(user, issue, rapidView));
        if (!issueEstimationForBoard.isValid()) {
            return this.responseFactory.errorsToResponse(issueEstimationForBoard.getErrors());
        }
        return ResponseFactory.okNoCache(this.createBeanForFieldValue((FieldValue)issueEstimationForBoard.get()));
    }

    @PUT
    @Path(value="{issueIdOrKey}/estimation")
    public Response estimateIssueForBoard(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="boardId") Long boardId, FieldEditBean fieldEditBean) {
        ServiceOutcome issueEstimationForBoard = this.doOperationInUserBoardIssueContext(boardId, issueIdOrKey, (user, rapidView, issue) -> this.rapidViewIssueService.estimateIssueForBoard(user, issue, rapidView, fieldEditBean.getValue()));
        if (!issueEstimationForBoard.isValid()) {
            return this.responseFactory.errorsToResponse(issueEstimationForBoard.getErrors());
        }
        return ResponseFactory.okNoCache(this.createBeanForFieldValue((FieldValue)issueEstimationForBoard.get()));
    }

    private <T> ServiceOutcome<T> doOperationInUserBoardIssueContext(Long boardId, String issueIdOrKey, FunctionInUserBoardIssueContext<T> function) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        ServiceResult validateUser = this.licenseService.validateUser(user);
        if (!validateUser.isValid()) {
            return ServiceOutcomeImpl.error(validateUser);
        }
        if (boardId == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.view.error.rapid.view.id", new Object[0]);
        }
        ServiceOutcome<RapidViewIssue> issue = this.getRapidViewIssueFromIdOrKey(user, issueIdOrKey);
        if (!issue.isValid()) {
            return ServiceOutcomeImpl.error(issue);
        }
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, boardId);
        if (!rapidView.isValid()) {
            return ServiceOutcomeImpl.error(rapidView);
        }
        return function.apply(user, rapidView.get(), issue.get().getIssue());
    }

    private FieldValueBean createBeanForFieldValue(FieldValue fieldValue) {
        return new FieldValueBean(fieldValue.getFieldId(), fieldValue.getValue());
    }

    private ServiceOutcome<RapidViewIssue> getRapidViewIssueFromIdOrKey(@Nullable ApplicationUser user, String issueIdOrKey) {
        ServiceOutcome<Either<Long, IssueKey>> idOrKey = IssueResourceHelper.getIssueIdOrKey(issueIdOrKey);
        if (!idOrKey.isValid()) {
            return ServiceOutcomeImpl.error(idOrKey);
        }
        return (ServiceOutcome)idOrKey.get().fold(issueId -> this.rapidViewIssueService.getIssueById(user, (Long)issueId), issueKey -> this.rapidViewIssueService.getIssueByKey(user, (IssueKey)issueKey));
    }

    private static interface FunctionInUserBoardIssueContext<T> {
        public ServiceOutcome<T> apply(ApplicationUser var1, RapidView var2, Issue var3);
    }
}

