/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest;

import com.atlassian.greenhopper.api.rank.RankChange;
import com.atlassian.greenhopper.api.rank.RankService;
import com.atlassian.greenhopper.api.rest.bean.EpicBeanFactory;
import com.atlassian.greenhopper.api.rest.bean.EpicRankRequestBean;
import com.atlassian.greenhopper.api.rest.bean.EpicRankRequestBeanValidator;
import com.atlassian.greenhopper.api.rest.bean.EpicUpdateBean;
import com.atlassian.greenhopper.api.rest.bean.IssueAssignRequestBean;
import com.atlassian.greenhopper.api.rest.bean.IssueListForBulkEditRetriever;
import com.atlassian.greenhopper.api.rest.util.IssueResourceHelper;
import com.atlassian.greenhopper.api.rest.util.ResponseFactory;
import com.atlassian.greenhopper.api.rest.util.ServiceOutcomeImpl;
import com.atlassian.greenhopper.license.LicenseService;
import com.atlassian.greenhopper.model.Epic;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.issue.RapidViewIssueService;
import com.atlassian.greenhopper.service.issuelink.EpicService;
import com.atlassian.greenhopper.service.issuelink.IssueLinkRequest;
import com.atlassian.greenhopper.service.issuelink.IssueUnlinkRequest;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueKey;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Either;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="epic")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public final class EpicResource {
    private final EpicService epicService;
    private final EpicBeanFactory epicBeanFactory;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final LicenseService licenseService;
    private final ResponseFactory responseFactory;
    private final IssueResourceHelper issueResourceHelper;
    private final IssueListForBulkEditRetriever issueListForBulkEditRetriever;
    private final RapidViewIssueService rapidViewIssueService;
    private final EpicRankRequestBeanValidator epicRankRequestBeanValidator;
    private final RankService rankService;
    private final IssueService issueService;

    public EpicResource(EpicService epicService, EpicBeanFactory epicBeanFactory, JiraAuthenticationContext jiraAuthenticationContext, LicenseService licenseService, ResponseFactory responseFactory, IssueResourceHelper issueResourceHelper, IssueListForBulkEditRetriever issueListForBulkEditRetriever, RapidViewIssueService rapidViewIssueService, EpicRankRequestBeanValidator epicRankRequestBeanValidator, RankService rankService, IssueService issueService) {
        this.epicService = epicService;
        this.epicBeanFactory = epicBeanFactory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.licenseService = licenseService;
        this.responseFactory = responseFactory;
        this.issueResourceHelper = issueResourceHelper;
        this.issueListForBulkEditRetriever = issueListForBulkEditRetriever;
        this.rapidViewIssueService = rapidViewIssueService;
        this.epicRankRequestBeanValidator = epicRankRequestBeanValidator;
        this.rankService = rankService;
        this.issueService = issueService;
    }

    @GET
    @Path(value="{epicIdOrKey}")
    public Response getEpic(@PathParam(value="epicIdOrKey") String epicIdOrKey) {
        return this.withValidatedLoggedInUser(user -> this.withEpic((ApplicationUser)user, epicIdOrKey, epic -> ResponseFactory.okNoCache(this.epicBeanFactory.toBean((Epic)epic))));
    }

    @GET
    @Path(value="none/issue")
    public Response getIssuesWithoutEpic(@QueryParam(value="startAt") Long startAt, @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="jql") String jql, @QueryParam(value="validateQuery") Boolean validateQuery, @QueryParam(value="fields") List<StringList> fields, @QueryParam(value="expand") String expand) {
        return this.withValidatedLoggedInUser(user -> this.issueResourceHelper.searchIssueByQueryParams((ApplicationUser)user, jql, validateQuery, startAt, maxResults, fields, expand, (pageRequest, query) -> this.rapidViewIssueService.getIssuesWithoutEpic((ApplicationUser)user, pageRequest, query)));
    }

    @GET
    @Path(value="{epicIdOrKey}/issue")
    public Response getIssuesForEpic(@PathParam(value="epicIdOrKey") String epicIdOrKey, @QueryParam(value="startAt") Long startAt, @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="jql") String jql, @QueryParam(value="validateQuery") Boolean validateQuery, @QueryParam(value="fields") List<StringList> fields, @QueryParam(value="expand") String expand) {
        return this.withValidatedLoggedInUser(user -> this.withEpic((ApplicationUser)user, epicIdOrKey, epic -> this.issueResourceHelper.searchIssueByQueryParams((ApplicationUser)user, jql, validateQuery, startAt, maxResults, fields, expand, (pageRequest, query) -> this.rapidViewIssueService.getIssuesForEpic((ApplicationUser)user, (Epic)epic, pageRequest, query))));
    }

    @POST
    @Path(value="none/issue")
    public Response removeIssuesFromEpic(IssueAssignRequestBean issueAssignRequestBean) {
        return this.withValidatedLoggedInUser(user -> {
            ServiceOutcome<Iterable<Issue>> issues = this.issueListForBulkEditRetriever.retrieveIssuesFromKeysAndIds((ApplicationUser)user, (Iterable<String>)issueAssignRequestBean.getIssues());
            if (!issues.isValid()) {
                return this.responseFactory.errorsToResponse(issues.getErrors());
            }
            ServiceResult issueAssignmentResult = this.epicService.removeEpicFromIssues(IssueUnlinkRequest.unlinkEpic(user, (Set<Issue>)ImmutableSet.copyOf(issues.get())));
            if (!issueAssignmentResult.isValid()) {
                return this.responseFactory.errorsToResponse(issueAssignmentResult.getErrors());
            }
            return ResponseFactory.noContent();
        });
    }

    @POST
    @Path(value="{epicIdOrKey}/issue")
    public Response moveIssuesToEpic(@PathParam(value="epicIdOrKey") String epicIdOrKey, IssueAssignRequestBean issueAssignRequestBean) {
        return this.withValidatedLoggedInUser(user -> this.withEpic((ApplicationUser)user, epicIdOrKey, epic -> {
            ServiceOutcome<Iterable<Issue>> issues = this.issueListForBulkEditRetriever.retrieveIssuesFromKeysAndIds((ApplicationUser)user, (Iterable<String>)issueAssignRequestBean.getIssues());
            if (!issues.isValid()) {
                return this.responseFactory.errorsToResponse(issues.getErrors());
            }
            IssueLinkRequest issueLinkRequest = IssueLinkRequest.linkEpic(user, epic, (Set<Issue>)ImmutableSet.copyOf(issues.get()));
            ServiceResult issueAssignmentResult = this.epicService.addIssuesToEpic(issueLinkRequest);
            if (!issueAssignmentResult.isValid()) {
                return this.responseFactory.errorsToResponse(issueAssignmentResult.getErrors());
            }
            return ResponseFactory.noContent();
        }));
    }

    @PUT
    @Path(value="{epicIdOrKey}/rank")
    public Response rankEpics(@PathParam(value="epicIdOrKey") String epicIdOrKey, EpicRankRequestBean epicRankRequestBean) {
        return this.withValidatedLoggedInUser(user -> this.withEpic((ApplicationUser)user, epicIdOrKey, epic -> {
            ServiceOutcome<EpicRankRequestBeanValidator.ValidRankRequest> validEpicRankRequestOutcome = this.epicRankRequestBeanValidator.validateRankRequest((ApplicationUser)user, epicRankRequestBean);
            if (!validEpicRankRequestOutcome.isValid()) {
                return this.responseFactory.errorsToResponse(validEpicRankRequestOutcome.getErrors());
            }
            EpicRankRequestBeanValidator.ValidRankRequest validRankRequest = validEpicRankRequestOutcome.get();
            ServiceOutcome<RankChange> rankChangesOutcome = this.rankEpic((Epic)epic, validRankRequest, (ApplicationUser)user);
            if (!rankChangesOutcome.isValid()) {
                return this.responseFactory.errorsToResponse(rankChangesOutcome.getErrors());
            }
            return ResponseFactory.noContent();
        }));
    }

    @POST
    @Path(value="{epicIdOrKey}")
    public Response partiallyUpdateEpic(@PathParam(value="epicIdOrKey") String epicIdOrKey, EpicUpdateBean epicUpdateBean) {
        return this.withValidatedLoggedInUser(user -> this.withEpic((ApplicationUser)user, epicIdOrKey, originalEpic -> {
            Epic newEpic = this.updateEpicProperties(epicUpdateBean, (Epic)originalEpic);
            ServiceOutcome<Epic> updateOutcome = this.epicService.updateEpic((ApplicationUser)user, newEpic);
            if (!updateOutcome.isValid()) {
                return this.responseFactory.errorsToResponse(updateOutcome.getErrors());
            }
            return ResponseFactory.okNoCache(this.epicBeanFactory.toBean(updateOutcome.get()));
        }));
    }

    private Epic updateEpicProperties(EpicUpdateBean epicUpdateBean, Epic originalEpic) {
        Optional<String> newColorKey = Optional.ofNullable(epicUpdateBean.getColor()).map(colorBean -> colorBean.getKey().getKey());
        return Epic.builder(originalEpic).name(Optional.ofNullable(epicUpdateBean.getName()).orElse(originalEpic.getName())).summary(Optional.ofNullable(epicUpdateBean.getSummary()).orElse(originalEpic.getSummary())).colorKey(newColorKey.orElse(originalEpic.getColorKey())).done(Optional.ofNullable(epicUpdateBean.isDone()).orElse(originalEpic.isDone())).build();
    }

    private ServiceOutcome<RankChange> rankEpic(Epic epic, EpicRankRequestBeanValidator.ValidRankRequest validRankRequest, ApplicationUser user) {
        IssueService.IssueResult issueResult = this.issueService.getIssue(user, epic.getId());
        Long rankFieldId = validRankRequest.getRankCustomFieldId();
        Epic rankToEpic = validRankRequest.getPositionEpic();
        IssueService.IssueResult rankToIssueResult = this.issueService.getIssue(user, rankToEpic.getId());
        if (validRankRequest.isRankBefore()) {
            return ServiceOutcomeImpl.from(this.rankService.rankBefore(user, (long)rankFieldId, (Issue)issueResult.getIssue(), (Issue)rankToIssueResult.getIssue()));
        }
        return ServiceOutcomeImpl.from(this.rankService.rankAfter(user, (long)rankFieldId, (Issue)issueResult.getIssue(), (Issue)rankToIssueResult.getIssue()));
    }

    private Response withValidatedLoggedInUser(Function<ApplicationUser, Response> fn) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        ServiceResult validateUser = this.licenseService.validateUser(user);
        if (!validateUser.isValid()) {
            return this.responseFactory.errorsToResponse(validateUser.getErrors());
        }
        return fn.apply(user);
    }

    private Response withEpic(ApplicationUser user, String epicIdOrKey, Function<Epic, Response> fn) {
        ServiceOutcome<Either<Long, IssueKey>> idOrKey = IssueResourceHelper.getEpicIdOrKey(epicIdOrKey);
        if (!idOrKey.isValid()) {
            return this.responseFactory.errorsToResponse(idOrKey);
        }
        ServiceOutcome epic = (ServiceOutcome)idOrKey.get().fold(epicId -> this.epicService.getEpic(user, (Long)epicId), epicKey -> this.epicService.getEpic(user, epicKey.toString()));
        if (!epic.isValid()) {
            return this.responseFactory.errorsToResponse(epic.getErrors());
        }
        return fn.apply((Epic)epic.get());
    }
}

