/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest;

import com.atlassian.greenhopper.api.rest.bean.BeanFactories;
import com.atlassian.greenhopper.api.rest.bean.PageBeanFactory;
import com.atlassian.greenhopper.api.rest.bean.SprintBeanFactory;
import com.atlassian.greenhopper.api.rest.util.BoardResourceHelper;
import com.atlassian.greenhopper.api.rest.util.IssueResourceHelper;
import com.atlassian.greenhopper.api.rest.util.QueryParamParser;
import com.atlassian.greenhopper.api.rest.util.Requests;
import com.atlassian.greenhopper.api.rest.util.ResponseFactory;
import com.atlassian.greenhopper.api.rest.util.ServiceOutcomeImpl;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.Page;
import com.atlassian.greenhopper.service.PageRequest;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.issue.RapidViewIssue;
import com.atlassian.greenhopper.service.issue.RapidViewIssueService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintQuery;
import com.atlassian.greenhopper.service.sprint.SprintService;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="board/{boardId}/sprint")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public final class BoardSprintResource {
    private static final Integer RETURNED_SPRINTS_LIMIT = 50;
    private final SprintService sprintService;
    private final SprintBeanFactory sprintBeanFactory;
    private final ResponseFactory responseFactory;
    private final RapidViewIssueService rapidViewIssueService;
    private final BoardResourceHelper boardResourceHelper;
    private final IssueResourceHelper issueResourceHelper;

    public BoardSprintResource(SprintService sprintService, SprintBeanFactory sprintBeanFactory, ResponseFactory responseFactory, RapidViewIssueService rapidViewIssueService, BoardResourceHelper boardResourceHelper, IssueResourceHelper issueResourceHelper) {
        this.sprintService = sprintService;
        this.sprintBeanFactory = sprintBeanFactory;
        this.responseFactory = responseFactory;
        this.rapidViewIssueService = rapidViewIssueService;
        this.boardResourceHelper = boardResourceHelper;
        this.issueResourceHelper = issueResourceHelper;
    }

    @GET
    public Response getAllSprints(@PathParam(value="boardId") Long boardId, final @QueryParam(value="startAt") Long startAt, final @QueryParam(value="maxResults") Integer maxResults, final @QueryParam(value="state") StringList state) {
        return this.boardResourceHelper.executeWithBoard(boardId, new BoardResourceHelper.WithBoardAction(){

            @Override
            public Response apply(ApplicationUser user, RapidView rapidView) {
                ServiceOutcome sprintQuery = BoardSprintResource.this.getSprintQuery(state);
                if (!sprintQuery.isValid()) {
                    return BoardSprintResource.this.responseFactory.errorsToResponse(sprintQuery.getErrors());
                }
                PageRequest pageRequest = Requests.requestWithLimit(startAt, maxResults, RETURNED_SPRINTS_LIMIT);
                ServiceOutcome<Page<Sprint>> sprintPage = BoardSprintResource.this.sprintService.getSprints(user, rapidView, pageRequest, (SprintQuery)sprintQuery.get());
                if (!sprintPage.isValid()) {
                    return BoardSprintResource.this.responseFactory.errorsToResponse(sprintPage.getErrors());
                }
                return ResponseFactory.okNoCache(PageBeanFactory.createPageBean(sprintPage.get(), BeanFactories.toBeanFunction(BoardSprintResource.this.sprintBeanFactory)));
            }
        });
    }

    private ServiceOutcome<SprintQuery> getSprintQuery(StringList statesNames) {
        SprintQuery.Builder queryBuilder = SprintQuery.builder();
        if (statesNames != null && !statesNames.asList().isEmpty()) {
            ServiceOutcome<Set<Sprint.State>> states = QueryParamParser.parseEnumSet("state", (List<String>)statesNames.asList(), Sprint.State.class);
            if (!states.isValid()) {
                return ServiceOutcomeImpl.error(states);
            }
            queryBuilder.states(states.get());
        }
        return ServiceOutcomeImpl.ok(queryBuilder.build());
    }

    @GET
    @Path(value="{sprintId}/issue")
    public Response getIssuesForSprint(@PathParam(value="boardId") Long boardId, final @PathParam(value="sprintId") Long sprintId, @QueryParam(value="startAt") Long startAt, @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="jql") String jql, @QueryParam(value="validateQuery") Boolean validateQuery, @QueryParam(value="fields") List<StringList> fields, @QueryParam(value="expand") String expand) {
        return this.issueResourceHelper.searchIssueByQueryParamsForBoard(boardId, jql, validateQuery, startAt, maxResults, fields, expand, new IssueResourceHelper.BoardIssueSearchAction(){

            @Override
            public ServiceOutcome<Page<RapidViewIssue>> apply(ApplicationUser user, RapidView rapidView, PageRequest pageRequest, Query query) {
                ServiceOutcome<Sprint> sprint = BoardSprintResource.this.sprintService.getSprint(user, sprintId);
                if (!sprint.isValid()) {
                    return ServiceOutcomeImpl.error(sprint);
                }
                return BoardSprintResource.this.rapidViewIssueService.getIssuesForSprintInBoardContext(user, rapidView, sprint.get(), pageRequest, query);
            }
        });
    }
}

