/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest;

import com.atlassian.greenhopper.api.rest.bean.PageBeanFactory;
import com.atlassian.greenhopper.api.rest.util.BoardResourceHelper;
import com.atlassian.greenhopper.api.rest.util.Requests;
import com.atlassian.greenhopper.api.rest.util.ResponseFactory;
import com.atlassian.greenhopper.service.Page;
import com.atlassian.greenhopper.service.PageRequest;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rapid.ProjectRapidViewService;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.ProjectJsonBean;
import com.atlassian.jira.project.Project;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="board/{boardId}/project")
@Produces(value={"application/json"})
public final class BoardProjectResource {
    private static final Integer RETURNED_PROJECTS_LIMIT = 50;
    private final ResponseFactory responseFactory;
    private final BoardResourceHelper boardResourceHelper;
    private final ProjectRapidViewService projectRapidViewService;
    private final JiraBaseUrls jiraBaseUrls;

    public BoardProjectResource(ResponseFactory responseFactory, BoardResourceHelper boardResourceHelper, ProjectRapidViewService projectRapidViewService, JiraBaseUrls jiraBaseUrls) {
        this.responseFactory = responseFactory;
        this.boardResourceHelper = boardResourceHelper;
        this.projectRapidViewService = projectRapidViewService;
        this.jiraBaseUrls = jiraBaseUrls;
    }

    @GET
    public Response getProjects(@PathParam(value="boardId") Long boardId, @QueryParam(value="startAt") Long startAt, @QueryParam(value="maxResults") Integer maxResults) {
        return this.boardResourceHelper.executeWithBoard(boardId, (user, rapidView) -> {
            PageRequest pageRequest = Requests.requestWithLimit(startAt, maxResults, RETURNED_PROJECTS_LIMIT);
            ServiceOutcome<Page<Project>> projects = this.projectRapidViewService.findProjectsByRapidView(user, rapidView, pageRequest);
            if (!projects.isValid()) {
                return this.responseFactory.errorsToResponse(projects.getErrors());
            }
            return ResponseFactory.okNoCache(PageBeanFactory.createPageBean(projects.get(), project -> ProjectJsonBean.shortBean((Project)project, (JiraBaseUrls)this.jiraBaseUrls)));
        });
    }
}

