/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest;

import com.atlassian.greenhopper.api.rest.bean.BeanFactories;
import com.atlassian.greenhopper.api.rest.bean.EpicBeanFactory;
import com.atlassian.greenhopper.api.rest.bean.PageBeanFactory;
import com.atlassian.greenhopper.api.rest.util.BoardResourceHelper;
import com.atlassian.greenhopper.api.rest.util.IssueResourceHelper;
import com.atlassian.greenhopper.api.rest.util.QueryParamParser;
import com.atlassian.greenhopper.api.rest.util.Requests;
import com.atlassian.greenhopper.api.rest.util.ResponseFactory;
import com.atlassian.greenhopper.api.rest.util.ServiceOutcomeImpl;
import com.atlassian.greenhopper.model.Epic;
import com.atlassian.greenhopper.service.Page;
import com.atlassian.greenhopper.service.PageRequest;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.issue.RapidViewIssueService;
import com.atlassian.greenhopper.service.issuelink.EpicQuery;
import com.atlassian.greenhopper.service.issuelink.EpicService;
import com.atlassian.jira.rest.api.util.StringList;
import java.util.List;
import javax.annotation.Nullable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="board/{boardId}/epic")
@Produces(value={"application/json"})
public final class BoardEpicResource {
    private static final Integer RETURNED_EPIC_LIMIT = 50;
    private final EpicService epicService;
    private final EpicBeanFactory epicBeanFactory;
    private final ResponseFactory responseFactory;
    private final BoardResourceHelper boardResourceHelper;
    private final IssueResourceHelper issueResourceHelper;
    private final RapidViewIssueService rapidViewIssueService;

    public BoardEpicResource(EpicService epicService, EpicBeanFactory epicBeanFactory, ResponseFactory responseFactory, BoardResourceHelper boardResourceHelper, IssueResourceHelper issueResourceHelper, RapidViewIssueService rapidViewIssueService) {
        this.epicService = epicService;
        this.epicBeanFactory = epicBeanFactory;
        this.responseFactory = responseFactory;
        this.boardResourceHelper = boardResourceHelper;
        this.issueResourceHelper = issueResourceHelper;
        this.rapidViewIssueService = rapidViewIssueService;
    }

    @GET
    public Response getEpics(@PathParam(value="boardId") Long boardId, @QueryParam(value="startAt") Long startAt, @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="done") String done) {
        return this.boardResourceHelper.executeWithBoard(boardId, (user, rapidView) -> {
            ServiceOutcome<EpicQuery> query = this.getEpicQuery(done);
            if (!query.isValid()) {
                return this.responseFactory.errorsToResponse(query.getErrors());
            }
            PageRequest pageRequest = Requests.requestWithLimit(startAt, maxResults, RETURNED_EPIC_LIMIT);
            ServiceOutcome<Page<Epic>> epics = this.epicService.getEpics(user, rapidView, pageRequest, query.get());
            if (!epics.isValid()) {
                return this.responseFactory.errorsToResponse(epics.getErrors());
            }
            return ResponseFactory.okNoCache(PageBeanFactory.createPageBean(epics.get(), BeanFactories.toBeanFunction(this.epicBeanFactory)));
        });
    }

    private ServiceOutcome<EpicQuery> getEpicQuery(@Nullable String doneStr) {
        EpicQuery.Builder builder = EpicQuery.builder();
        if (doneStr != null) {
            ServiceOutcome<Boolean> done = QueryParamParser.parseBoolean(doneStr, "done");
            if (!done.isValid()) {
                return ServiceOutcomeImpl.error(done);
            }
            builder.done(done.get());
        }
        return ServiceOutcomeImpl.ok(builder.build());
    }

    @GET
    @Path(value="none/issue")
    public Response getIssuesWithoutEpic(@PathParam(value="boardId") Long boardId, @QueryParam(value="startAt") Long startAt, @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="jql") String jql, @QueryParam(value="validateQuery") Boolean validateQuery, @QueryParam(value="fields") List<StringList> fields, @QueryParam(value="expand") String expand) {
        return this.issueResourceHelper.searchIssueByQueryParamsForBoard(boardId, jql, validateQuery, startAt, maxResults, fields, expand, this.rapidViewIssueService::getIssuesWithoutEpic);
    }

    @GET
    @Path(value="{epicId}/issue")
    public Response getIssuesForEpic(@PathParam(value="boardId") Long boardId, @PathParam(value="epicId") Long epicId, @QueryParam(value="startAt") Long startAt, @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="jql") String jql, @QueryParam(value="validateQuery") Boolean validateQuery, @QueryParam(value="fields") List<StringList> fields, @QueryParam(value="expand") String expand) {
        return this.issueResourceHelper.searchIssueByQueryParamsForBoard(boardId, jql, validateQuery, startAt, maxResults, fields, expand, (user, rapidView, pageRequest, query) -> {
            ServiceOutcome<Epic> epic = this.epicService.getEpic(user, epicId);
            if (!epic.isValid()) {
                return ServiceOutcomeImpl.error(epic);
            }
            return this.rapidViewIssueService.getIssuesForEpic(user, rapidView, epic.get(), pageRequest, query);
        });
    }
}

