/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest;

import com.atlassian.greenhopper.api.rest.bean.IssueAssignRequestBean;
import com.atlassian.greenhopper.api.rest.bean.IssueListForBulkEditRetriever;
import com.atlassian.greenhopper.api.rest.util.ResponseFactory;
import com.atlassian.greenhopper.license.LicenseService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.sprint.SprintIssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="backlog")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class BacklogResource {
    private final SprintIssueService sprintIssueService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final LicenseService licenseService;
    private final ResponseFactory responseFactory;
    private final IssueListForBulkEditRetriever issueListForBulkEditRetriever;

    public BacklogResource(SprintIssueService sprintIssueService, JiraAuthenticationContext jiraAuthenticationContext, LicenseService licenseService, ResponseFactory responseFactory, IssueListForBulkEditRetriever issueListForBulkEditRetriever) {
        this.sprintIssueService = sprintIssueService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.licenseService = licenseService;
        this.responseFactory = responseFactory;
        this.issueListForBulkEditRetriever = issueListForBulkEditRetriever;
    }

    @POST
    @Path(value="issue")
    public Response moveIssuesToBacklog(IssueAssignRequestBean issueAssignRequestBean) {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        ServiceResult validateUser = this.licenseService.validateUser(user);
        if (!validateUser.isValid()) {
            return this.responseFactory.errorsToResponse(validateUser.getErrors());
        }
        ServiceOutcome<Iterable<Issue>> issues = this.issueListForBulkEditRetriever.retrieveIssuesFromKeysAndIds(user, issueAssignRequestBean.getIssues());
        if (!issues.isValid()) {
            return this.responseFactory.errorsToResponse(issues.getErrors());
        }
        ServiceResult issueAssignmentResult = this.sprintIssueService.moveIssuesToBacklog(user, (Collection<Issue>)ImmutableList.copyOf(issues.get()));
        if (!issueAssignmentResult.isValid()) {
            return this.responseFactory.errorsToResponse(issueAssignmentResult.getErrors());
        }
        return ResponseFactory.noContent();
    }
}

