/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rapid.view;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.greenhopper.api.rapid.view.Column;
import com.atlassian.greenhopper.api.rapid.view.QuickFilter;
import com.atlassian.greenhopper.api.rapid.view.RapidViewCreationService;
import com.atlassian.greenhopper.api.rapid.view.StatisticsField;
import com.atlassian.greenhopper.api.rapid.view.Swimlane;
import com.atlassian.greenhopper.customfield.CustomFieldConfigurationRestorer;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldConfig;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.model.validation.ErrorCollectionTransformer;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.QuickFilterService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPresetService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.rapid.view.StatisticsFieldService;
import com.atlassian.greenhopper.service.rapid.view.SwimlaneService;
import com.atlassian.greenhopper.web.rapid.view.RapidViewPreset;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class RapidViewCreationServiceImpl
implements RapidViewCreationService {
    @Autowired
    private CustomFieldConfigurationRestorer customFieldConfigurationRestorer;
    @Autowired
    private RapidViewService rapidViewService;
    @Autowired
    private ColumnService columnService;
    @Autowired
    private StatisticsFieldService statisticsFieldService;
    @Autowired
    private QuickFilterService quickFilterService;
    @Autowired
    private SwimlaneService swimlaneService;
    @Autowired
    private ErrorCollectionTransformer errorCollectionTransformer;
    private static final String DEFAULT_SWIMLANE_NAME = "gh.rapid.swimlane.default.name";

    @Override
    @Deprecated
    public Long createNewRapidView(User user, String name, long filterId, com.atlassian.jira.util.ErrorCollection errors) {
        return this.createNewRapidView(ApplicationUsers.from((User)user), name, filterId, errors);
    }

    @Override
    @Deprecated
    public void setStatusMappings(User user, long rapidViewId, List<Column> columns, com.atlassian.jira.util.ErrorCollection errors) {
        this.setStatusMappings(ApplicationUsers.from((User)user), rapidViewId, columns, errors);
    }

    @Override
    @Deprecated
    public void setQuickFilters(User user, long rapidViewId, List<QuickFilter> quickFilters, com.atlassian.jira.util.ErrorCollection errors) {
        this.setQuickFilters(ApplicationUsers.from((User)user), rapidViewId, quickFilters, errors);
    }

    @Override
    @Deprecated
    public void setSwimlanes(User user, long rapidViewId, List<Swimlane> swimlanes, com.atlassian.jira.util.ErrorCollection errors) {
        this.setSwimlanes(ApplicationUsers.from((User)user), rapidViewId, swimlanes, errors);
    }

    @Override
    @Deprecated
    public void setStatisticsField(User user, long rapidViewId, StatisticsField statisticsField, com.atlassian.jira.util.ErrorCollection errors) {
        this.setStatisticsField(ApplicationUsers.from((User)user), rapidViewId, statisticsField, errors);
    }

    @Override
    public Long createNewRapidView(ApplicationUser user, String name, long filterId, com.atlassian.jira.util.ErrorCollection errors) {
        RapidViewPreset preset = RapidViewPreset.KANBAN;
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.create(user, name, filterId, preset);
        if (!rapidView.isValid()) {
            errors.addErrorCollection(this.errorCollectionTransformer.toJiraErrorCollection(rapidView.getErrors(), user));
            return null;
        }
        this.customFieldConfigurationRestorer.ensureFieldsAreCorrectlyConfigured(Collections.emptyList(), RapidViewPresetService.getAssociatedProjectType(preset), CustomFieldConfigurationRestorer.ScreenSchemeOption.USE_EXISTING_SCREEN_SCHEME);
        return rapidView.get().getId();
    }

    @Override
    public void setStatusMappings(ApplicationUser user, long rapidViewId, List<Column> columns, com.atlassian.jira.util.ErrorCollection errors) {
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
        if (!rapidView.isValid()) {
            errors.addErrorCollection(this.errorCollectionTransformer.toJiraErrorCollection(rapidView.getErrors(), user));
            return;
        }
        ArrayList<com.atlassian.greenhopper.model.rapid.Column> newCols = new ArrayList<com.atlassian.greenhopper.model.rapid.Column>(columns.size());
        for (Column col : columns) {
            Column.ColumnBuilder columnBuilder = com.atlassian.greenhopper.model.rapid.Column.builder().name(col.getName());
            for (Status status : col.getStatuses()) {
                columnBuilder.statusId(status.getId());
            }
            newCols.add(columnBuilder.build());
        }
        ServiceOutcome<List<com.atlassian.greenhopper.model.rapid.Column>> listServiceOutcome = this.columnService.updateColumns(user, rapidView.getValue(), newCols);
        if (!listServiceOutcome.isValid()) {
            errors.addErrorCollection(this.errorCollectionTransformer.toJiraErrorCollection(listServiceOutcome.getErrors(), user));
        }
    }

    @Override
    public void setQuickFilters(ApplicationUser user, long rapidViewId, List<QuickFilter> quickFilters, com.atlassian.jira.util.ErrorCollection errors) {
        ArrayList<com.atlassian.greenhopper.model.rapid.QuickFilter> newQuickFilters = new ArrayList<com.atlassian.greenhopper.model.rapid.QuickFilter>(quickFilters.size());
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
        if (!rapidView.isValid()) {
            errors.addErrorCollection(this.errorCollectionTransformer.toJiraErrorCollection(rapidView.getErrors(), user));
            return;
        }
        for (QuickFilter quickFilter : quickFilters) {
            newQuickFilters.add(com.atlassian.greenhopper.model.rapid.QuickFilter.builder().name(quickFilter.getName()).query(quickFilter.getQuery()).description(quickFilter.getDescription()).build());
        }
        ServiceOutcome<List<com.atlassian.greenhopper.model.rapid.QuickFilter>> outcome = this.quickFilterService.set(user, rapidView.getValue(), newQuickFilters);
        if (!outcome.isValid()) {
            errors.addErrorCollection(this.errorCollectionTransformer.toJiraErrorCollection(outcome.getErrors(), user));
        }
    }

    @Override
    public void setSwimlanes(ApplicationUser user, long rapidViewId, List<Swimlane> swimlanes, com.atlassian.jira.util.ErrorCollection errors) {
        ArrayList<com.atlassian.greenhopper.model.rapid.Swimlane> newSwimlanes = new ArrayList<com.atlassian.greenhopper.model.rapid.Swimlane>(swimlanes.size());
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
        if (!rapidView.isValid()) {
            errors.addErrorCollection(this.errorCollectionTransformer.toJiraErrorCollection(rapidView.getErrors(), user));
            return;
        }
        for (Swimlane swimlane : swimlanes) {
            newSwimlanes.add(com.atlassian.greenhopper.model.rapid.Swimlane.builder().name(swimlane.getName()).query(swimlane.getQuery()).description(swimlane.getDescription()).build());
        }
        newSwimlanes.add(com.atlassian.greenhopper.model.rapid.Swimlane.builder().name(DEFAULT_SWIMLANE_NAME).query("").description("").defaultLane(true).build());
        ServiceOutcome<List<com.atlassian.greenhopper.model.rapid.Swimlane>> outcome = this.swimlaneService.replace(user, rapidView.getValue(), newSwimlanes);
        if (!outcome.isValid()) {
            errors.addErrorCollection(this.errorCollectionTransformer.toJiraErrorCollection(outcome.getErrors(), user));
        }
    }

    @Override
    public void setStatisticsField(ApplicationUser user, long rapidViewId, StatisticsField statisticsField, com.atlassian.jira.util.ErrorCollection errors) {
        StatisticsFieldConfig newStatisticsField;
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
        if (!rapidView.isValid()) {
            errors.addErrorCollection(this.errorCollectionTransformer.toJiraErrorCollection(rapidView.getErrors(), user));
            return;
        }
        switch (statisticsField.getType()) {
            case ISSUE_COUNT: {
                newStatisticsField = StatisticsFieldConfig.buildIssueCount();
                break;
            }
            case ISSUE_COUNT_EXCL_SUBS: {
                newStatisticsField = StatisticsFieldConfig.buildIssueCountExcludingSubs();
                break;
            }
            case NONE: {
                newStatisticsField = StatisticsFieldConfig.buildNone();
                break;
            }
            default: {
                throw new RuntimeException("Unknown statistics field type encountered: " + (Object)((Object)statisticsField.getType()));
            }
        }
        ErrorCollection intErrors = new ErrorCollection();
        this.statisticsFieldService.updateStatisticsField(user, intErrors, rapidView.getValue(), newStatisticsField);
        if (intErrors.hasErrors()) {
            errors.addErrorCollection(this.errorCollectionTransformer.toJiraErrorCollection(intErrors, user));
        }
    }
}

