/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rapid.view;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.issue.status.Status;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@PublicApi
public class Column {
    private final String name;
    private final List<Status> statuses;
    private final Integer min;
    private final Integer max;

    @Deprecated
    public Column(String name, List<Status> statuses) {
        this.name = name;
        this.statuses = statuses;
        this.min = null;
        this.max = null;
    }

    private Column(String name, List<Status> statuses, Integer min, Integer max) {
        this.name = name;
        this.min = min;
        this.max = max;
        this.statuses = statuses;
    }

    public String getName() {
        return this.name;
    }

    public List<Status> getStatuses() {
        return this.statuses;
    }

    @Nullable
    public Integer getMin() {
        return this.min;
    }

    @Nullable
    public Integer getMax() {
        return this.max;
    }

    public static ColumnBuilder builder() {
        return new ColumnBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Column column = (Column)o;
        return Objects.equal((Object)this.name, (Object)column.name) && Objects.equal((Object)this.min, (Object)column.min) && Objects.equal((Object)this.max, (Object)column.max) && Objects.equal(this.statuses, column.statuses);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.min, this.max, this.statuses});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nameKey", (Object)this.name).add("min", (Object)this.min).add("max", (Object)this.max).add("statuses", this.statuses).toString();
    }

    public static class ColumnBuilder {
        private String name;
        private Integer min;
        private Integer max;
        private List<Status> statuses = new ArrayList<Status>();

        public ColumnBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ColumnBuilder min(Integer min) {
            this.min = min;
            return this;
        }

        public ColumnBuilder max(Integer max) {
            this.max = max;
            return this;
        }

        public ColumnBuilder statuses(List<Status> statuses) {
            this.statuses = statuses;
            return this;
        }

        public ColumnBuilder status(Status status) {
            this.statuses.add(status);
            return this;
        }

        public Column build() {
            return new Column(this.name, this.statuses, this.min, this.max);
        }
    }
}

