/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rank;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.greenhopper.api.ResultFactory;
import com.atlassian.greenhopper.api.rank.RankChange;
import com.atlassian.greenhopper.api.rank.RankChangesOutcome;
import com.atlassian.greenhopper.api.rank.RankService;
import com.atlassian.greenhopper.customfield.lexorank.LexoRankCustomFieldService;
import com.atlassian.greenhopper.model.lexorank.LexoRank;
import com.atlassian.greenhopper.service.rank.RankException;
import com.atlassian.greenhopper.service.rank.RankableFactory;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;

@ParametersAreNonnullByDefault
public class RankServiceImpl
implements RankService {
    @Autowired
    private ResultFactory resultFactory;
    @Autowired
    private com.atlassian.greenhopper.service.rank.RankService rankService;
    @Autowired
    private LexoRankCustomFieldService rankCustomFieldService;
    @Autowired
    private RankableFactory rankableFactory;
    @Autowired
    JiraAuthenticationContext authenticationContext;

    @Override
    @Nonnull
    @Deprecated
    public ServiceOutcome<RankChange> rankBefore(@Nullable User user, long customFieldId, Issue issue, Issue rankBeforeIssue) {
        return this.rankBefore(ApplicationUsers.from((User)user), customFieldId, issue, rankBeforeIssue);
    }

    @Override
    @Nonnull
    @Deprecated
    public ServiceOutcome<RankChange> rankAfter(@Nullable User user, long customFieldId, Issue issue, Issue rankAfterIssue) {
        return this.rankAfter(ApplicationUsers.from((User)user), customFieldId, issue, rankAfterIssue);
    }

    @Override
    @Nonnull
    @Deprecated
    public ServiceOutcome<RankChange> rankFirst(@Nullable User user, long customFieldId, Issue issue) {
        return this.rankFirst(ApplicationUsers.from((User)user), customFieldId, issue);
    }

    @Override
    @Nonnull
    @Deprecated
    public ServiceOutcome<RankChange> rankLast(@Nullable User user, long customFieldId, Issue issue) {
        return this.rankLast(ApplicationUsers.from((User)user), customFieldId, issue);
    }

    @Override
    @Nonnull
    public ServiceOutcome<RankChange> rankBefore(@Nullable ApplicationUser user, long customFieldId, Issue issue, Issue rankBeforeIssue) {
        com.atlassian.greenhopper.service.ServiceOutcome<RankChange> rankChange = this.rankService.rankBefore(user, customFieldId, this.rankableFactory.fromIssue(issue), this.rankableFactory.fromIssue(rankBeforeIssue));
        return this.resultFactory.makeJiraOutcome(rankChange, user);
    }

    @Override
    @Nonnull
    public ServiceOutcome<RankChangesOutcome> rankBefore(@Nullable ApplicationUser user, long customFieldId, @Nonnull List<Issue> issues, @Nonnull Issue rankBeforeIssue) {
        com.atlassian.greenhopper.service.ServiceOutcome<RankChangesOutcome> rankChange = this.rankService.rankBefore(user, customFieldId, this.rankableFactory.fromIssues(issues), this.rankableFactory.fromIssue(rankBeforeIssue));
        return this.resultFactory.makeJiraOutcome(rankChange, user);
    }

    @Override
    @Nonnull
    public ServiceOutcome<RankChange> rankAfter(@Nullable ApplicationUser user, long customFieldId, Issue issue, Issue rankAfterIssue) {
        com.atlassian.greenhopper.service.ServiceOutcome<RankChange> rankChange = this.rankService.rankAfter(user, customFieldId, this.rankableFactory.fromIssue(issue), this.rankableFactory.fromIssue(rankAfterIssue));
        return this.resultFactory.makeJiraOutcome(rankChange, user);
    }

    @Override
    @Nonnull
    public ServiceOutcome<RankChangesOutcome> rankAfter(@Nullable ApplicationUser user, long customFieldId, @Nonnull List<Issue> issues, @Nonnull Issue rankAfterIssue) {
        com.atlassian.greenhopper.service.ServiceOutcome<RankChangesOutcome> rankChange = this.rankService.rankAfter(user, customFieldId, this.rankableFactory.fromIssues(issues), this.rankableFactory.fromIssue(rankAfterIssue));
        return this.resultFactory.makeJiraOutcome(rankChange, user);
    }

    @Override
    @Nonnull
    public ServiceOutcome<RankChange> rankFirst(@Nullable ApplicationUser user, long customFieldId, Issue issue) {
        com.atlassian.greenhopper.service.ServiceOutcome<RankChange> rankChange = this.rankService.rankFirst(user, customFieldId, this.rankableFactory.fromIssue(issue));
        return this.resultFactory.makeJiraOutcome(rankChange, user);
    }

    @Override
    @Nonnull
    public ServiceOutcome<RankChange> rankLast(@Nullable ApplicationUser user, long customFieldId, Issue issue) {
        com.atlassian.greenhopper.service.ServiceOutcome<RankChange> rankChange = this.rankService.rankLast(user, customFieldId, this.rankableFactory.fromIssue(issue));
        return this.resultFactory.makeJiraOutcome(rankChange, user);
    }

    @Override
    @Nonnull
    public int compareIssuePosition(long customFieldId, Issue first, Issue second) {
        com.atlassian.greenhopper.service.ServiceOutcome<LexoRank> firstRank = this.rankService.getRankablePosition(customFieldId, this.rankableFactory.fromIssue(first));
        if (firstRank.isInvalid()) {
            throw new RankException();
        }
        com.atlassian.greenhopper.service.ServiceOutcome<LexoRank> secondRank = this.rankService.getRankablePosition(customFieldId, this.rankableFactory.fromIssue(second));
        if (secondRank.isInvalid()) {
            throw new RankException();
        }
        return firstRank.getValue().compareTo(secondRank.getValue());
    }

    @Override
    public boolean isRankField(long customFieldId) {
        return this.rankCustomFieldService.isRankField(customFieldId);
    }

    @Override
    @Nonnull
    public Collection<CustomField> getRankFields() {
        return Lists.newArrayList((Iterable)Iterables.filter(this.rankCustomFieldService.getRankFields(), (Predicate)new Predicate<CustomField>(){

            public boolean apply(CustomField input) {
                return RankServiceImpl.this.isRankField(input.getIdAsLong());
            }
        }));
    }

    @Override
    @Nonnull
    public ServiceOutcome<CustomField> getDefaultRankField() {
        CustomField field = this.rankCustomFieldService.getDefaultRankField();
        return this.resultFactory.makeOkOrNotFoundResult(field, "gh.api.rank.error.default.field.not.found");
    }
}

