/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.issuetype;

import com.atlassian.greenhopper.api.ResultFactory;
import com.atlassian.greenhopper.api.issuetype.ManagedIssueTypesService;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.issuetype.IssueType;
import org.springframework.beans.factory.annotation.Autowired;

public class ManagedIssueTypesServiceImpl
implements ManagedIssueTypesService {
    @Autowired
    private IssueTypeService issueTypeService;
    @Autowired
    private ResultFactory resultFactory;

    @Override
    public ServiceOutcome<IssueType> getStoryIssueType() {
        return this.toOutcome(this.issueTypeService.getOrCreateStoryIssueType(), "gh.api.issuetype.error.story.not.found");
    }

    @Override
    public ServiceOutcome<IssueType> getEpicIssueType() {
        return this.toOutcome(this.issueTypeService.getOrCreateEpicIssueType(), "gh.api.issuetype.error.epic.not.found");
    }

    private <T> ServiceOutcome<T> toOutcome(T value, String errorMessage) {
        return this.resultFactory.makeOkOrNotFoundResult(value, errorMessage);
    }
}

