/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.customfield;

import com.atlassian.greenhopper.api.ResultFactory;
import com.atlassian.greenhopper.api.customfield.ManagedCustomFieldsService;
import com.atlassian.greenhopper.customfield.lexorank.LexoRankCustomFieldService;
import com.atlassian.greenhopper.manager.issue.fields.StoryPointsCustomFieldProvider;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.greenhopper.service.sprint.SprintCustomFieldService;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.fields.CustomField;
import org.springframework.beans.factory.annotation.Autowired;

public class ManagedCustomFieldsServiceImpl
implements ManagedCustomFieldsService {
    @Autowired
    private StoryPointsCustomFieldProvider storyPointsCustomFieldProvider;
    @Autowired
    private EpicCustomFieldService epicCustomFieldService;
    @Autowired
    private SprintCustomFieldService sprintCustomFieldService;
    @Autowired
    private LexoRankCustomFieldService rankCustomFieldService;
    @Autowired
    private ResultFactory resultFactory;

    @Override
    public ServiceOutcome<CustomField> getStoryPointsCustomField() {
        return this.toOutcome(this.storyPointsCustomFieldProvider.getOrCreateDefaultField(), "gh.api.customfield.error.story.points.not.found");
    }

    @Override
    public ServiceOutcome<CustomField> getEpicNameCustomField() {
        return this.toOutcome(this.epicCustomFieldService.getDefaultEpicLabelField(), "gh.api.customfield.error.epic.name.not.found");
    }

    @Override
    public ServiceOutcome<CustomField> getEpicLinkCustomField() {
        return this.toOutcome(this.epicCustomFieldService.getDefaultEpicLinkField(), "gh.api.customfield.error.epic.link.not.found");
    }

    @Override
    public ServiceOutcome<CustomField> getEpicColorCustomField() {
        return this.toOutcome(this.epicCustomFieldService.getDefaultEpicColorField(), "gh.api.customfield.error.epic.color.not.found");
    }

    @Override
    public ServiceOutcome<CustomField> getEpicStatusCustomField() {
        return this.toOutcome(this.epicCustomFieldService.getDefaultEpicStatusField(), "gh.api.customfield.error.epic.status.not.found");
    }

    @Override
    public ServiceOutcome<CustomField> getSprintCustomField() {
        return this.toOutcome(this.sprintCustomFieldService.getDefaultSprintField(), "gh.api.customfield.error.sprint.not.found");
    }

    @Override
    public ServiceOutcome<CustomField> getRankCustomField() {
        return this.toOutcome(this.rankCustomFieldService.getDefaultRankField(), "gh.api.customfield.error.rank.not.found");
    }

    private <T> ServiceOutcome<T> toOutcome(T value, String errorMessage) {
        return this.resultFactory.makeOkOrNotFoundResult(value, errorMessage);
    }
}

