/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.model.validation.ErrorCollectionTransformer;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.user.ApplicationUser;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResultFactory {
    @Autowired
    private ErrorCollectionTransformer errorCollectionTransformer;

    public <T> ServiceOutcome<T> makeOkOrNotFoundResult(@Nullable T payload, String notFoundErrorMessageKey) {
        if (payload == null) {
            ErrorCollection errors = new ErrorCollection();
            errors.addError(ErrorCollection.Reason.NOT_FOUND, notFoundErrorMessageKey, new Object[0]);
            return ServiceOutcomeImpl.from((com.atlassian.jira.util.ErrorCollection)this.errorCollectionTransformer.toJiraErrorCollection(errors), null);
        }
        return ServiceOutcomeImpl.ok(payload);
    }

    public <T> ServiceOutcome<T> makeJiraOutcome(com.atlassian.greenhopper.service.ServiceOutcome<T> serviceOutcome, ApplicationUser user) {
        if (serviceOutcome.isInvalid()) {
            return this.makeJiraErrorOutcome(serviceOutcome, user);
        }
        return ServiceOutcomeImpl.ok(serviceOutcome.getValue());
    }

    public <T, S> ServiceOutcome<T> makeJiraErrorOutcome(com.atlassian.greenhopper.service.ServiceOutcome<S> serviceOutcome, ApplicationUser user) {
        return new ServiceOutcomeImpl(this.errorCollectionTransformer.toJiraErrorCollection(serviceOutcome.getErrors(), user));
    }
}

