/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.anonymization;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.greenhopper.manager.color.CardColorAO;
import com.atlassian.greenhopper.manager.color.CardColorManager;
import com.atlassian.greenhopper.manager.rapidview.BoardAdminManager;
import com.atlassian.greenhopper.model.rapid.BoardAdmin;
import com.atlassian.greenhopper.model.rapid.CardColorStrategy;
import com.atlassian.greenhopper.service.rapid.RapidViewCacheManager;
import com.atlassian.greenhopper.service.rapid.view.BoardAdminAO;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.UserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RapidViewUserKeyChangeHandler
implements UserKeyChangeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RapidViewUserKeyChangeHandler.class);
    private final ActiveObjects ao;
    private final BoardAdminManager boardAdminManager;
    private final CardColorManager cardColorManager;
    private final RapidViewCacheManager rapidViewCacheManager;
    private final I18nHelper i18n;

    @Autowired
    public RapidViewUserKeyChangeHandler(ActiveObjects ao, BoardAdminManager boardAdminManager, CardColorManager cardColorManager, RapidViewCacheManager rapidViewCacheManager, I18nHelper i18n) {
        this.ao = ao;
        this.boardAdminManager = boardAdminManager;
        this.cardColorManager = cardColorManager;
        this.rapidViewCacheManager = rapidViewCacheManager;
        this.i18n = i18n;
    }

    @Nonnull
    public Collection<AffectedEntity> getAffectedEntities(@Nonnull UserPropertyChangeParameter parameter) {
        long boardAdmins = this.ao.count(BoardAdminAO.class, "TYPE = ? AND KEY = ?", new Object[]{BoardAdmin.Type.USER.toString(), parameter.getOriginal()});
        long cardColors = this.ao.count(CardColorAO.class, "STRATEGY = ? AND VAL = ?", new Object[]{CardColorStrategy.ASSIGNEE.getId(), parameter.getOriginal()});
        long rapidViews = this.ao.count(RapidViewAO.class, "OWNER_USER_NAME = ?", new Object[]{parameter.getOriginal()});
        return Stream.of(this.affectedEntity("gh.user.anonymize.board.admin", boardAdmins), this.affectedEntity("gh.rapid.config.cardcolors.title", cardColors), this.affectedEntity("gh.user.anonymize.rapid.view", rapidViews)).flatMap(Function.identity()).collect(Collectors.toList());
    }

    private Stream<AffectedEntity> affectedEntity(String i18nKey, long number) {
        if (number > 0L) {
            return Stream.of(AffectedEntity.newBuilder((AffectedEntityType)AffectedEntityType.ANONYMIZE).descriptionKey(i18nKey).numberOfOccurrences(Long.valueOf(number)).build());
        }
        return Stream.of(new AffectedEntity[0]);
    }

    @Nonnull
    public ServiceResult update(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        Throwable throwable;
        Context.Task task;
        String original = userPropertyChangeParameter.getOriginal();
        String target = userPropertyChangeParameter.getTarget();
        SimpleErrorCollection error = new SimpleErrorCollection();
        try {
            task = userPropertyChangeParameter.getContext().start(null);
            throwable = null;
            try {
                this.updateBoardAdmins(original, target);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (task != null) {
                    if (throwable != null) {
                        try {
                            task.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        task.close();
                    }
                }
            }
        }
        catch (Exception e) {
            error.addErrorMessage(this.i18n.getText("change.handler.processing.exception", e.getMessage()));
            LOG.error("Error when changing user key in board admins", (Throwable)e);
        }
        try {
            task = userPropertyChangeParameter.getContext().start(null);
            throwable = null;
            try {
                this.updateCardColors(original, target);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (task != null) {
                    if (throwable != null) {
                        try {
                            task.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        task.close();
                    }
                }
            }
        }
        catch (Exception e) {
            error.addErrorMessage(this.i18n.getText("change.handler.processing.exception", e.getMessage()));
            LOG.error("Error when changing user key in card colors", (Throwable)e);
        }
        try {
            task = userPropertyChangeParameter.getContext().start(null);
            throwable = null;
            try {
                this.updateRapidViews(original, target);
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (task != null) {
                    if (throwable != null) {
                        try {
                            task.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        task.close();
                    }
                }
            }
        }
        catch (Exception e) {
            error.addErrorMessage(this.i18n.getText("change.handler.processing.exception", e.getMessage()));
            LOG.error("Error when changing user key in boards", (Throwable)e);
        }
        return new ServiceResultImpl((ErrorCollection)error);
    }

    private void updateBoardAdmins(String original, String target) {
        for (BoardAdminAO boardAdmin : (BoardAdminAO[])this.ao.find(BoardAdminAO.class, "TYPE = ? AND KEY = ?", new Object[]{BoardAdmin.Type.USER.toString(), original})) {
            boardAdmin.setKey(target);
            boardAdmin.save();
        }
        this.boardAdminManager.flushCache();
    }

    private void updateCardColors(String original, String target) {
        for (CardColorAO cardColor : (CardColorAO[])this.ao.find(CardColorAO.class, "STRATEGY = ? AND VAL = ?", new Object[]{CardColorStrategy.ASSIGNEE.getId(), original})) {
            cardColor.setVal(target);
            cardColor.save();
        }
        this.cardColorManager.flushCache();
    }

    private void updateRapidViews(String original, String target) {
        for (RapidViewAO rapidView : (RapidViewAO[])this.ao.find(RapidViewAO.class, "OWNER_USER_NAME = ?", new Object[]{original})) {
            rapidView.setOwnerUserName(target);
            rapidView.save();
            this.rapidViewCacheManager.remove(rapidView.getId());
        }
    }

    public int getNumberOfTasks(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        return 3;
    }
}

