/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.anonymization;

import com.atlassian.greenhopper.manager.audit.AuditEntryManager;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.UserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditEntryKeyChangeHandler
implements UserKeyChangeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AuditEntryKeyChangeHandler.class);
    private final AuditEntryManager auditEntryManager;
    private final I18nHelper i18n;

    public AuditEntryKeyChangeHandler(AuditEntryManager auditEntryManager, I18nHelper i18n) {
        this.auditEntryManager = auditEntryManager;
        this.i18n = i18n;
    }

    @Nonnull
    public Collection<AffectedEntity> getAffectedEntities(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        long entries = this.auditEntryManager.countByUserKey(userPropertyChangeParameter.getOriginal());
        if (entries > 0L) {
            return ImmutableList.of((Object)AffectedEntity.newBuilder((AffectedEntityType)AffectedEntityType.ANONYMIZE).numberOfOccurrences(Long.valueOf(entries)).descriptionKey("gh.user.anonymize.audit.entry").build());
        }
        return ImmutableList.of();
    }

    @Nonnull
    public ServiceResult update(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        SimpleErrorCollection error = new SimpleErrorCollection();
        try (Context.Task ignore = userPropertyChangeParameter.getContext().start(null);){
            this.auditEntryManager.changeUserKey(userPropertyChangeParameter.getOriginal(), userPropertyChangeParameter.getTarget());
        }
        catch (Exception e) {
            error.addErrorMessage(this.i18n.getText("change.handler.processing.exception", e.getMessage()));
            LOG.error("Error when changing user key in audit entries", (Throwable)e);
        }
        return new ServiceResultImpl((ErrorCollection)error);
    }

    public int getNumberOfTasks(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        return 1;
    }
}

