/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.analytics;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.greenhopper.analytics.AnalyticTask;
import com.atlassian.greenhopper.analytics.BasicStatsAnalyticTask;
import com.atlassian.greenhopper.analytics.JiraAgileStartAnalyticEvent;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgileStartupAnalyticsPublisher {
    private final Logger logger = LoggerFactory.getLogger(AgileStartupAnalyticsPublisher.class);
    @Autowired
    private EventPublisher eventPublisher;
    @Autowired
    private BasicStatsAnalyticTask basicStatsTask;

    public void publishAnaliticsData() {
        List<? extends AnalyticTask> tasks = this.getTasksToRun();
        MapBuilder builder = MapBuilder.newBuilder();
        for (AnalyticTask analyticTask : tasks) {
            try {
                builder.addAll(analyticTask.getAnalytics());
            }
            catch (Exception e) {
                this.logger.error(" Error trying to grab analytics from [{}]", (Object)analyticTask.getClass().getName(), (Object)e);
            }
        }
        this.eventPublisher.publish((Object)new JiraAgileStartAnalyticEvent(builder.toMap()));
    }

    private List<? extends AnalyticTask> getTasksToRun() {
        return ImmutableList.of((Object)this.basicStatsTask);
    }
}

