/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.greenhopper.EventListenerRegistry;
import com.atlassian.greenhopper.analytics.AgileStartupAnalyticsPublisher;
import com.atlassian.greenhopper.auditing.AuditingEventListener;
import com.atlassian.greenhopper.customfield.epiclink.EpicLinkIssueEventListener;
import com.atlassian.greenhopper.customfield.lexorank.LexoRankCFListener;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.issue.RemoveFutureSprintsFromClosedIssuesListener;
import com.atlassian.greenhopper.license.LicenseService;
import com.atlassian.greenhopper.manager.issue.fields.IssueTypeRestorer;
import com.atlassian.greenhopper.manager.issue.fields.ManagedFieldConfigurationRestorer;
import com.atlassian.greenhopper.manager.version.VersionAdapterFactory;
import com.atlassian.greenhopper.plugin.module.ModuleLoader;
import com.atlassian.greenhopper.project.PermissionSchemeProjectCreateHandler;
import com.atlassian.greenhopper.service.BridgeServiceLocator;
import com.atlassian.greenhopper.service.GreenHopperCacheManager;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.index.IndexCheckService;
import com.atlassian.greenhopper.service.lexorank.LexoRankIssueEventListener;
import com.atlassian.greenhopper.service.lexorank.LexoRankStatisticsAgent;
import com.atlassian.greenhopper.service.lexorank.balance.LexoRankBalancingService;
import com.atlassian.greenhopper.service.logging.LogSupport;
import com.atlassian.greenhopper.service.logging.LoggingConfiguration;
import com.atlassian.greenhopper.service.osgi.JiraProjectsOsgiLinkEnforcer;
import com.atlassian.greenhopper.service.query.QueryToProjectMapper;
import com.atlassian.greenhopper.service.rank.RankIndexServiceImpl;
import com.atlassian.greenhopper.util.database.SupportedDatabaseChecker;
import com.atlassian.greenhopper.workflow.SimplifiedWorkflow70UpgradeService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.project.ProjectCreateHandler;
import com.atlassian.jira.project.ProjectCreateRegistrar;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.pocketknife.api.lifecycle.modules.ModuleRegistrationHandle;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import io.atlassian.util.concurrent.LazyReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;

public class Launcher
implements LifecycleAware {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    private EventPublisher eventPublisher;
    @Autowired
    private EventListenerRegistry eventListenerRegistry;
    @Autowired
    private RankIndexServiceImpl rankIndexService;
    @Autowired
    private LexoRankIssueEventListener lexoRankIssueEventListener;
    @Autowired
    private EpicLinkIssueEventListener epicLinkIssueEventListener;
    @Autowired
    private GreenHopperCacheManager greenHopperCacheManager;
    @Autowired
    private LogSupport logSupport;
    @Autowired
    private LoggingConfiguration loggingConfiguration;
    @Autowired
    private ManagedFieldConfigurationRestorer managedFieldConfigurationRestorer;
    @Autowired
    private IssueTypeRestorer issueTypeRestorer;
    @Autowired
    private CustomFieldManager customFieldManager;
    @Autowired
    private VersionAdapterFactory versionAdapterFactory;
    @Autowired
    private FeatureManager featureManager;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private ModuleLoader moduleLoader;
    @Autowired
    private LexoRankCFListener lexoRankCFListener;
    @Autowired
    private LexoRankBalancingService lexoRankBalancingService;
    @Autowired
    private LexoRankStatisticsAgent lexoRankStatisticsAgent;
    @Autowired
    private IndexCheckService indexCheckService;
    @Autowired
    private RemoveFutureSprintsFromClosedIssuesListener removeFutureSprintsFromClosedIssuesListener;
    @Autowired
    private AgileStartupAnalyticsPublisher agileStartupAnalyticsPublisher;
    @Autowired
    private JiraProjectsOsgiLinkEnforcer jiraProjectsOsgiLinkEnforcer;
    @Autowired
    private QueryToProjectMapper queryToProjectMapper;
    @Autowired
    private SupportedDatabaseChecker supportedDatabaseChecker;
    @Autowired
    private ProjectCreateRegistrar projectCreateRegistrar;
    @Autowired
    private PermissionSchemeProjectCreateHandler permissionSchemeProjectCreateHandler;
    @Autowired
    private SimplifiedWorkflow70UpgradeService simplifiedWorkflow70UpgradeService;
    @Autowired
    private AuditingEventListener auditingEventListener;
    private final Set<SystemPhase> systemPhases = Collections.synchronizedSet(new HashSet(SystemPhase.values().length));
    private final LazyReference<FullSystemInitialiser> fullSystemInitialiser = new LazyReference<FullSystemInitialiser>(){

        @Override
        protected FullSystemInitialiser create() throws Exception {
            return new FullSystemInitialiser();
        }
    };
    private AtomicReference<ModuleRegistrationHandle> moduleRegistraionHandle = new AtomicReference();

    @PostConstruct
    public void onSpringContextStarted() {
        this.supportedDatabaseChecker.check();
        this.eventPublisher.register((Object)this);
        this.loggingConfiguration.configureAgileLoggers();
        this.logSupport.onPluginStarting();
        this.registerListeners();
        this.onSystemStartPhase(SystemPhase.SPRING_STARTED);
    }

    public void onStart() {
        this.scheduleJobs();
        this.onSystemStartPhase(SystemPhase.LIFECYCLE_AWARE_STARTED);
    }

    @EventListener
    public final void onPluginStarted(PluginEnabledEvent pluginEnabledEvent) {
        if (pluginEnabledEvent.getPlugin().getKey().equals("com.pyxis.greenhopper.jira")) {
            this.logSupport.onPluginStarted();
            this.onSystemStartPhase(SystemPhase.PLUGIN_ENABLED);
        }
    }

    private void onSystemStartPhase(SystemPhase newPhase) {
        this.systemPhases.add(newPhase);
        if (this.systemPhases.size() == SystemPhase.values().length) {
            this.fullSystemInitialiser.get();
            this.agileStartupAnalyticsPublisher.publishAnaliticsData();
        }
    }

    @EventListener
    public final void onClearCache(ClearCacheEvent clearCacheEvent) {
        this.logSupport.onClearCache();
    }

    @PreDestroy
    public void onSpringContextStopped() {
        this.logSupport.onPluginStopping();
        this.unloadDynamicModules();
        this.unscheduleJobs();
        this.destroyCaches();
        this.destroyServices();
        this.unregisterListeners();
        try {
            BridgeServiceLocator.clear();
        }
        catch (Throwable t) {
            this.log.exception(t);
        }
        this.eventPublisher.unregister((Object)this);
        this.logSupport.onPluginStopped();
    }

    public void onStop() {
    }

    private void registerListeners() {
        this.registerIssueListeners();
        this.eventListenerRegistry.registerListener(EventListenerRegistry.ListenerKey.CACHE_MANAGER, this.greenHopperCacheManager);
        this.eventListenerRegistry.registerListener(EventListenerRegistry.ListenerKey.RANK_INDEX_SERVICE, this.rankIndexService);
        this.eventListenerRegistry.registerListener(EventListenerRegistry.ListenerKey.LEXO_RANK_FIELD, this.lexoRankCFListener);
        this.eventListenerRegistry.registerListener(EventListenerRegistry.ListenerKey.LEXO_RANK_BALANCING_EVENT, this.lexoRankBalancingService);
        this.eventListenerRegistry.registerListener(EventListenerRegistry.ListenerKey.INDEX_CHECK_SERVICE, this.indexCheckService);
        this.eventListenerRegistry.registerListener(EventListenerRegistry.ListenerKey.QUERY_MAPPER_CACHE, this.queryToProjectMapper);
        this.eventListenerRegistry.registerListener(EventListenerRegistry.ListenerKey.AUDIT_LOG, this.auditingEventListener);
        this.registerProjectCreateListener();
    }

    private void scheduleJobs() {
    }

    private void unscheduleJobs() {
    }

    private void unregisterListeners() {
        this.log.info("Unregistering listeners", new Object[0]);
        try {
            this.unregisterProjectCreateListener();
        }
        catch (Throwable t) {
            this.log.exception(t);
        }
        try {
            this.eventListenerRegistry.unregisterAll();
        }
        catch (Throwable t) {
            this.log.exception(t);
        }
    }

    private void destroyServices() {
        this.log.info("Destroying services", new Object[0]);
        try {
            this.rankIndexService.selfDestruct();
        }
        catch (Throwable t) {
            this.log.exception(t);
        }
        this.lexoRankStatisticsAgent.stop();
    }

    private void destroyCaches() {
        this.log.info("Destroying caches", new Object[0]);
        try {
            this.greenHopperCacheManager.clearCaches(null);
        }
        catch (Throwable t) {
            this.log.exception(t);
        }
    }

    private void registerIssueListeners() {
        this.eventListenerRegistry.registerListener(EventListenerRegistry.ListenerKey.LEXO_RANK, this.lexoRankIssueEventListener);
        this.eventListenerRegistry.registerListener(EventListenerRegistry.ListenerKey.EPIC_LINK, this.epicLinkIssueEventListener);
        this.eventListenerRegistry.registerListener(EventListenerRegistry.ListenerKey.ISSUE_CLOSED, this.removeFutureSprintsFromClosedIssuesListener);
    }

    private void registerProjectCreateListener() {
        this.projectCreateRegistrar.register((ProjectCreateHandler)this.permissionSchemeProjectCreateHandler);
    }

    private void unregisterProjectCreateListener() {
        this.projectCreateRegistrar.register((ProjectCreateHandler)this.permissionSchemeProjectCreateHandler);
    }

    private void loadDynamicModules() {
        this.log.info("Registering dynamic modules", new Object[0]);
        this.moduleRegistraionHandle.set(this.moduleLoader.load());
    }

    private void unloadDynamicModules() {
        ModuleRegistrationHandle handle = this.moduleRegistraionHandle.getAndSet(null);
        if (handle == null) {
            return;
        }
        this.log.info("Unregistering dynamic modules is being skipped", new Object[0]);
    }

    private void onFullSystemStart() {
        this.greenHopperCacheManager.notifyPluginAlive();
        this.jiraProjectsOsgiLinkEnforcer.execute();
        ServiceResult restoreOutcome = this.managedFieldConfigurationRestorer.restoreAndLockFields();
        if (restoreOutcome.isInvalid()) {
            this.log.info("Restore failed: %s", restoreOutcome.getErrors().toString());
        }
        this.issueTypeRestorer.restoreIssueTypes();
        this.versionAdapterFactory.migrate();
        this.simplifiedWorkflow70UpgradeService.doUpgrade();
        this.loadDynamicModules();
        this.lexoRankBalancingService.initialise();
        this.lexoRankStatisticsAgent.start();
    }

    private void onFullSystemStartLicensed(boolean onDemand) {
        this.logSupport.onFullSystemStartLicensed();
    }

    private class FullSystemInitialiser {
        private FullSystemInitialiser() {
            Launcher.this.customFieldManager.refresh();
            Launcher.this.onFullSystemStart();
            if (Launcher.this.licenseService.isLicensed()) {
                boolean onDemand = Launcher.this.featureManager.isOnDemand();
                Launcher.this.onFullSystemStartLicensed(onDemand);
            }
        }
    }

    private static enum SystemPhase {
        SPRING_STARTED,
        PLUGIN_ENABLED,
        LIFECYCLE_AWARE_STARTED;

    }
}

