/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.greenhopper.global.LoggerWrapper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EventListenerRegistry {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    private EventPublisher eventPublisher;
    private Map<ListenerKey, Object> eventListeners = new ConcurrentHashMap<ListenerKey, Object>();

    public void registerListener(ListenerKey key, Object listener) {
        this.eventPublisher.register(listener);
        this.eventListeners.put(key, listener);
        this.log.info("registered event listener [%s]: %s", new Object[]{key, listener.getClass().getName()});
    }

    public void unregisterAll() {
        for (ListenerKey key : this.eventListeners.keySet()) {
            this.unregisterListener(key);
        }
    }

    public void unregisterListener(ListenerKey key) {
        Object listener = this.eventListeners.get((Object)key);
        if (listener != null) {
            this.eventPublisher.unregister(listener);
            this.eventListeners.remove((Object)key);
            this.log.info("unregistered event listener [%s]: %s", new Object[]{key, listener.getClass().getName()});
        }
    }

    public Object getListener(ListenerKey key) {
        return this.eventListeners.get((Object)key);
    }

    public static enum ListenerKey {
        LAUNCHER,
        CACHE_MANAGER,
        RANK_INDEX_SERVICE,
        PLUGIN_DISABLED,
        EPIC_LINK,
        LEXO_RANK,
        LEXO_RANK_FIELD,
        LEXO_RANK_BALANCING_EVENT,
        INDEX_CHECK_SERVICE,
        ISSUE_CLOSED,
        QUERY_MAPPER_CACHE,
        AUDIT_LOG;

    }
}

