/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.compat;

import com.atlassian.annotations.PublicApi;
import com.atlassian.cache.compat.Cache;
import com.atlassian.cache.compat.CacheFactory;
import com.atlassian.cache.compat.CacheLoader;
import com.atlassian.cache.compat.CacheSettings;
import com.atlassian.cache.compat.CachedReference;
import com.atlassian.cache.compat.Supplier;
import com.atlassian.cache.compat.memory.MemoryCacheFactory;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicApi
public class CompatibilityCacheFactory
implements CacheFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CompatibilityCacheFactory.class);
    private static final String CACHE_SETTINGS_CLASS = "com.atlassian.cache.CacheSettings";
    private static final String DELEGATING_CACHE_MANAGER_CLASS = "com.atlassian.cache.compat.delegate.DelegatingCacheFactory";
    private final CacheFactory delegate = this.isAtlassianCache2xAvailable() ? this.getDelegatingCacheFactory() : new MemoryCacheFactory();

    @Override
    public <V> CachedReference<V> getCachedReference(@Nonnull String name, @Nonnull Supplier<V> supplier) {
        return this.delegate.getCachedReference(name, supplier);
    }

    @Override
    public <V> CachedReference<V> getCachedReference(@Nonnull String name, @Nonnull Supplier<V> supplier, @Nonnull CacheSettings required) {
        return this.delegate.getCachedReference(name, supplier, required);
    }

    @Override
    public <V> CachedReference<V> getCachedReference(@Nonnull Class<?> owningClass, @Nonnull String name, @Nonnull Supplier<V> supplier) {
        return this.delegate.getCachedReference(owningClass, name, supplier);
    }

    @Override
    public <V> CachedReference<V> getCachedReference(@Nonnull Class<?> owningClass, @Nonnull String name, @Nonnull Supplier<V> supplier, @Nonnull CacheSettings required) {
        return this.delegate.getCachedReference(owningClass, name, supplier, required);
    }

    @Override
    public <K, V> Cache<K, V> getCache(@Nonnull String name) {
        return this.delegate.getCache(name);
    }

    @Override
    public <K, V> Cache<K, V> getCache(@Nonnull Class<?> owningClass, @Nonnull String name) {
        return this.delegate.getCache(owningClass, name);
    }

    @Override
    public <K, V> Cache<K, V> getCache(@Nonnull String name, CacheLoader<K, V> loader) {
        return this.delegate.getCache(name, loader);
    }

    @Override
    public <K, V> Cache<K, V> getCache(@Nonnull String name, CacheLoader<K, V> loader, @Nonnull CacheSettings required) {
        return this.delegate.getCache(name, loader, required);
    }

    @Override
    @Deprecated
    public <K, V> Cache<K, V> getCache(@Nonnull String name, @Nonnull Class<K> keyType, @Nonnull Class<V> valueType) {
        return this.delegate.getCache(name, keyType, valueType);
    }

    CacheFactory getDelegate() {
        return this.delegate;
    }

    CacheFactory getDelegatingCacheFactory() {
        try {
            return (CacheFactory)this.getClass().getClassLoader().loadClass(DELEGATING_CACHE_MANAGER_CLASS).newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpectedly failed to initialize delegation to atlassian-cache-api", e);
        }
        catch (LinkageError e) {
            throw new IllegalStateException("An unexpected binary incompatibility prevented delegation to atlassian-cache-api", e);
        }
    }

    boolean isAtlassianCache2xAvailable() {
        try {
            this.getClass().getClassLoader().loadClass(CACHE_SETTINGS_CLASS);
            return true;
        }
        catch (ClassNotFoundException e) {
            LOG.debug("ClassLoader is not a defined class; using non-cluster-safe implementation", (Throwable)e);
            return false;
        }
    }
}

