/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issuelink;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class IssueUnlinkRequest {
    private final ApplicationUser user;
    private final Set<Issue> issuesToUnlink;
    private final boolean dispatchEvent;

    public static IssueUnlinkRequest unlinkEpic(@Nullable ApplicationUser user, Set<Issue> issuesToUnlink) {
        return new IssueUnlinkRequest(user, issuesToUnlink, true);
    }

    public IssueUnlinkRequest withoutDispatchingEvent() {
        return new IssueUnlinkRequest(this.user, this.issuesToUnlink, false);
    }

    private IssueUnlinkRequest(@Nullable ApplicationUser user, Set<Issue> issuesToUnlink, boolean dispatchEvent) {
        this.user = user;
        this.issuesToUnlink = issuesToUnlink;
        this.dispatchEvent = dispatchEvent;
    }

    @Nullable
    public ApplicationUser getUser() {
        return this.user;
    }

    public Set<Issue> getIssuesToUnlink() {
        return this.issuesToUnlink;
    }

    public boolean isDispatchEvent() {
        return this.dispatchEvent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueUnlinkRequest that = (IssueUnlinkRequest)o;
        return this.dispatchEvent == that.dispatchEvent && Objects.equals(this.user, that.user) && Objects.equals(this.issuesToUnlink, that.issuesToUnlink);
    }

    public int hashCode() {
        return Objects.hash(this.user, this.issuesToUnlink, this.dispatchEvent);
    }

    public String toString() {
        return "IssueUnlinkRequest{user=" + this.user + ", issuesToUnlink=" + this.issuesToUnlink + ", dispatchEvent=" + this.dispatchEvent + '}';
    }
}

