/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.issuelink;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.fugue.Either;
import com.atlassian.greenhopper.model.Epic;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public final class IssueLinkRequest {
    private final ApplicationUser user;
    private final Either<Issue, Epic> epic;
    private final Set<Issue> issuesToLink;
    private final boolean dispatchEvent;

    public static IssueLinkRequest linkEpic(@Nullable ApplicationUser user, Issue epic, Set<Issue> issuesToLink) {
        return new IssueLinkRequest(user, (Either<Issue, Epic>)Either.left((Object)epic), issuesToLink, true);
    }

    public static IssueLinkRequest linkEpic(@Nullable ApplicationUser user, Epic epic, Set<Issue> issuesToLink) {
        return new IssueLinkRequest(user, (Either<Issue, Epic>)Either.right((Object)epic), issuesToLink, true);
    }

    public IssueLinkRequest withoutDispatchingEvent() {
        return new IssueLinkRequest(this.user, this.epic, this.issuesToLink, false);
    }

    private IssueLinkRequest(@Nullable ApplicationUser user, Either<Issue, Epic> epic, Set<Issue> issuesToLink, boolean dispatchEvent) {
        this.user = user;
        this.epic = epic;
        this.issuesToLink = issuesToLink;
        this.dispatchEvent = dispatchEvent;
    }

    @Nullable
    public ApplicationUser getUser() {
        return this.user;
    }

    public Either<Issue, Epic> getEpic() {
        return this.epic;
    }

    public Set<Issue> getIssuesToLink() {
        return this.issuesToLink;
    }

    public boolean isDispatchEvent() {
        return this.dispatchEvent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueLinkRequest that = (IssueLinkRequest)o;
        return Objects.equal((Object)this.user, (Object)that.user) && Objects.equal(this.epic, that.epic) && Objects.equal(this.issuesToLink, that.issuesToLink) && Objects.equal((Object)this.dispatchEvent, (Object)that.dispatchEvent);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.user, this.epic, this.issuesToLink, this.dispatchEvent});
    }

    public String toString() {
        return "IssueLinkRequest{user=" + this.user + ", epic=" + this.epic + ", issuesToLink=" + this.issuesToLink + ", dispatchEvent=" + this.dispatchEvent + '}';
    }
}

