/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.model;

import com.atlassian.annotations.ExperimentalApi;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

@ExperimentalApi
public class Epic {
    private final Long id;
    private final String key;
    private final String name;
    private final String summary;
    private final String colorKey;
    private final boolean done;

    private Epic(Long id, String key, String name, String summary, String colorKey, boolean done) {
        this.id = (Long)Preconditions.checkNotNull((Object)id);
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.name = Strings.nullToEmpty((String)name);
        this.summary = Strings.nullToEmpty((String)summary);
        this.colorKey = Strings.nullToEmpty((String)colorKey);
        this.done = done;
    }

    public Long getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getColorKey() {
        return this.colorKey;
    }

    public boolean isDone() {
        return this.done;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Epic data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Epic that = (Epic)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.key, (Object)that.key) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.colorKey, (Object)that.colorKey) && Objects.equal((Object)this.done, (Object)that.done);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.key, this.name, this.colorKey, this.done});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("issueId", (Object)this.id).add("issueKey", (Object)this.key).add("epicName", (Object)this.name).add("epicColor", (Object)this.colorKey).add("done", this.done).toString();
    }

    public static final class Builder {
        private Long id;
        private String key;
        private String summary;
        private String name;
        private String colorKey;
        private boolean done;

        private Builder() {
        }

        private Builder(Epic initialData) {
            this.id = initialData.id;
            this.key = initialData.key;
            this.name = initialData.name;
            this.summary = initialData.summary;
            this.colorKey = initialData.colorKey;
            this.done = initialData.done;
        }

        public Builder id(Long issueId) {
            this.id = issueId;
            return this;
        }

        public Builder key(String issueKey) {
            this.key = issueKey;
            return this;
        }

        public Builder name(String epicName) {
            this.name = epicName;
            return this;
        }

        public Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder colorKey(String epicColorKey) {
            this.colorKey = epicColorKey;
            return this;
        }

        public Builder done(boolean done) {
            this.done = done;
            return this;
        }

        public Epic build() {
            return new Epic(this.id, this.key, this.name, this.summary, this.colorKey, this.done);
        }
    }
}

