/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.license;

import com.atlassian.greenhopper.license.LicenseMode;
import com.google.common.annotations.VisibleForTesting;

public class LicenseInfo {
    private final LicenseMode licenseMode;
    private final boolean isLicensed;
    private final boolean isValidUser;

    private LicenseInfo(LicenseMode licenseMode, boolean isLicensed, boolean isValidUser) {
        this.licenseMode = licenseMode;
        this.isLicensed = isLicensed;
        this.isValidUser = isValidUser;
    }

    public static Builder builder() {
        return new Builder();
    }

    public LicenseMode getLicenseMode() {
        return this.licenseMode;
    }

    public boolean isLicensed() {
        return this.isLicensed;
    }

    public boolean isValidUser() {
        return this.isValidUser;
    }

    @VisibleForTesting
    public static class Builder {
        private LicenseMode licenseMode;
        private boolean isLicensed;
        private boolean isValidUser;

        public Builder setLicenseMode(LicenseMode licenseMode) {
            this.licenseMode = licenseMode;
            return this;
        }

        public Builder setLicensed(boolean isLicensed) {
            this.isLicensed = isLicensed;
            return this;
        }

        public Builder setValidUser(boolean isValidUser) {
            this.isValidUser = isValidUser;
            return this;
        }

        public LicenseInfo build() {
            return new LicenseInfo(this.licenseMode, this.isLicensed, this.isValidUser);
        }
    }
}

