/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.model;

import com.atlassian.annotations.ExperimentalApi;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

@ExperimentalApi
public class Epic {
    private final Long issueId;
    private final String issueKey;
    private final String epicName;
    private final String epicColor;
    private final boolean done;

    private Epic(Long issueId, String issueKey, String epicName, String epicColor, boolean done) {
        this.issueId = (Long)Preconditions.checkNotNull((Object)issueId);
        this.issueKey = (String)Preconditions.checkNotNull((Object)issueKey);
        this.epicName = (String)Preconditions.checkNotNull((Object)epicName);
        this.epicColor = (String)Preconditions.checkNotNull((Object)epicColor);
        this.done = done;
    }

    public Long getIssueId() {
        return this.issueId;
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    public String getEpicName() {
        return this.epicName;
    }

    public String getEpicColor() {
        return this.epicColor;
    }

    public boolean isDone() {
        return this.done;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Epic data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Epic that = (Epic)o;
        return Objects.equal((Object)this.issueId, (Object)that.issueId) && Objects.equal((Object)this.issueKey, (Object)that.issueKey) && Objects.equal((Object)this.epicName, (Object)that.epicName) && Objects.equal((Object)this.epicColor, (Object)that.epicColor) && Objects.equal((Object)this.done, (Object)that.done);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.issueId, this.issueKey, this.epicName, this.epicColor, this.done});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("issueId", (Object)this.issueId).add("issueKey", (Object)this.issueKey).add("epicName", (Object)this.epicName).add("epicColor", (Object)this.epicColor).add("done", this.done).toString();
    }

    public static final class Builder {
        private Long issueId;
        private String issueKey;
        private String epicName;
        private String epicColor;
        private boolean done;

        private Builder() {
        }

        private Builder(Epic initialData) {
            this.issueId = initialData.issueId;
            this.issueKey = initialData.issueKey;
            this.epicName = initialData.epicName;
            this.epicColor = initialData.epicColor;
            this.done = initialData.done;
        }

        public Builder setIssueId(Long issueId) {
            this.issueId = issueId;
            return this;
        }

        public Builder setIssueKey(String issueKey) {
            this.issueKey = issueKey;
            return this;
        }

        public Builder setEpicName(String epicName) {
            this.epicName = epicName;
            return this;
        }

        public Builder setEpicColor(String epicColor) {
            this.epicColor = epicColor;
            return this;
        }

        public Builder setDone(boolean done) {
            this.done = done;
            return this;
        }

        public Epic build() {
            return new Epic(this.issueId, this.issueKey, this.epicName, this.epicColor, this.done);
        }
    }
}

