/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.entity.remotelink.sprint;

import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public class RemoteSprintLink {
    private Long id;
    private Long sprintId;
    private String globalId;
    private String title;
    private String url;
    private String relationship;
    private ApplicationType applicationType;
    private String applicationName;

    public RemoteSprintLink(Long id, Long sprintId, String globalId, String title, String url, String relationship, ApplicationType applicationType, String applicationName) {
        this.id = id;
        this.sprintId = sprintId;
        this.globalId = globalId;
        this.title = title;
        this.url = url;
        this.relationship = relationship;
        this.applicationType = applicationType;
        this.applicationName = applicationName;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSprintId() {
        return this.sprintId;
    }

    public void setSprintId(Long sprintId) {
        this.sprintId = sprintId;
    }

    public String getGlobalId() {
        return this.globalId;
    }

    public void setGlobalId(String globalId) {
        this.globalId = globalId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getRelationship() {
        return this.relationship;
    }

    public void setRelationship(String relationship) {
        this.relationship = relationship;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public static enum ApplicationType {
        CONFLUENCE(RemoteIssueLink.APPLICATION_TYPE_CONFLUENCE);

        private String name;

        private ApplicationType(String name) {
            this.name = name;
        }

        public static boolean exists(String name) {
            for (ApplicationType appType : ApplicationType.values()) {
                if (!appType.getName().equals(name)) continue;
                return true;
            }
            return false;
        }

        public static ApplicationType resolve(String name) {
            for (ApplicationType appType : ApplicationType.values()) {
                if (!appType.getName().equals(name)) continue;
                return appType;
            }
            return null;
        }

        public static String listNamesAsCommaSeparatedString() {
            ArrayList appTypeNames = Lists.newArrayList();
            for (ApplicationType appType : ApplicationType.values()) {
                appTypeNames.add(appType.getName());
            }
            return StringUtils.join((Collection)appTypeNames, (String)",");
        }

        public String getName() {
            return this.name;
        }
    }
}

