/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.sprint;

import com.atlassian.annotations.ExperimentalApi;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.joda.time.DateTime;

@ExperimentalApi
public class Sprint {
    private final Long id;
    private final Long rapidViewId;
    private final State state;
    private final String name;
    private final DateTime startDate;
    private final DateTime endDate;
    private final DateTime completeDate;
    private final Long sequence;

    private Sprint(Long id, Long rapidViewId, State state, String name, DateTime startDate, DateTime endDate, DateTime completeDate, Long sequence) {
        this.id = id;
        this.rapidViewId = rapidViewId;
        this.state = state;
        this.name = name != null ? name.trim() : name;
        this.startDate = startDate;
        this.endDate = endDate;
        this.completeDate = completeDate;
        this.sequence = sequence;
    }

    public Long getId() {
        return this.id;
    }

    public Long getRapidViewId() {
        return this.rapidViewId;
    }

    public State getState() {
        return this.state;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public DateTime getStartDate() {
        return this.startDate;
    }

    @Nullable
    public DateTime getEndDate() {
        return this.endDate;
    }

    @Nullable
    public DateTime getCompleteDate() {
        return this.completeDate;
    }

    public Long getSequence() {
        return this.sequence;
    }

    public boolean isFuture() {
        return this.state == State.FUTURE;
    }

    public boolean isActive() {
        return this.state == State.ACTIVE;
    }

    public boolean isClosed() {
        return this.state == State.CLOSED;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sprint other = (Sprint)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static SprintBuilder builder() {
        return new SprintBuilder();
    }

    public static SprintBuilder builder(Sprint existing) {
        return new SprintBuilder().id(existing.getId()).rapidViewId(existing.getRapidViewId()).state(existing.getState()).name(existing.getName()).startDate(existing.getStartDate()).endDate(existing.getEndDate()).completeDate(existing.getCompleteDate()).sequence(existing.getSequence());
    }

    public static class SprintBuilder {
        private Long id;
        private Long rapidViewId;
        private State state = State.FUTURE;
        private String name;
        private DateTime startDate;
        private DateTime endDate;
        private DateTime completeDate;
        private Long sequence;

        public Sprint build() {
            return new Sprint(this.id, this.rapidViewId, this.state, this.name, this.startDate, this.endDate, this.completeDate, this.sequence);
        }

        public SprintBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public SprintBuilder rapidViewId(Long rapidViewId) {
            this.rapidViewId = rapidViewId;
            return this;
        }

        public SprintBuilder state(State state) {
            this.state = state;
            return this;
        }

        public SprintBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SprintBuilder startDate(DateTime startDate) {
            this.startDate = startDate;
            return this;
        }

        public SprintBuilder endDate(DateTime endDate) {
            this.endDate = endDate;
            return this;
        }

        public SprintBuilder completeDate(DateTime completeDate) {
            this.completeDate = completeDate;
            return this;
        }

        public SprintBuilder startDate(Long startDate) {
            this.startDate = SprintBuilder.toDateTime(startDate);
            return this;
        }

        public SprintBuilder endDate(Long endDate) {
            this.endDate = SprintBuilder.toDateTime(endDate);
            return this;
        }

        public SprintBuilder completeDate(Long completeDate) {
            this.completeDate = SprintBuilder.toDateTime(completeDate);
            return this;
        }

        public SprintBuilder sequence(Long sequence) {
            this.sequence = sequence;
            return this;
        }

        private static DateTime toDateTime(Long startDate) {
            return startDate == null ? null : new DateTime((Object)startDate);
        }
    }

    public static enum State {
        FUTURE,
        ACTIVE,
        CLOSED;

    }
}

